/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.request;

import com.qiniu.android.http.request.IUploadServer;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;

public class Request {
    public static final String HttpMethodGet = "GET";
    public static final String HttpMethodPOST = "POST";
    public final String urlString;
    public final String httpMethod;
    public final Map<String, String> allHeaders;
    public final int timeout;
    public byte[] httpBody;
    public String host;
    public String ip;
    protected IUploadServer uploadServer;

    public Request(String urlString, String httpMethod, Map<String, String> allHeaders, byte[] httpBody, int timeout) {
        this.urlString = urlString;
        this.httpMethod = httpMethod != null ? httpMethod : HttpMethodGet;
        this.allHeaders = allHeaders != null ? allHeaders : new HashMap();
        this.httpBody = httpBody != null ? httpBody : new byte[]{};
        this.timeout = timeout;
    }

    public InetAddress getInetAddress() {
        if (this.host == null || this.uploadServer == null || this.uploadServer.getIp() == null) {
            return null;
        }
        try {
            InetAddress ipAddress = InetAddress.getByName(this.uploadServer.getIp());
            return InetAddress.getByAddress(this.host, ipAddress.getAddress());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean isValid() {
        return this.urlString == null || this.httpMethod == null;
    }
}

