/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.request.httpclient;

import java.io.IOException;
import java.util.Arrays;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class ByteBody
extends RequestBody {
    private static final int SEGMENT_SIZE = 102400;
    private final MediaType mediaType;
    private final byte[] body;

    public ByteBody(MediaType mediaType, byte[] body) {
        this.mediaType = mediaType;
        this.body = body;
    }

    public MediaType contentType() {
        return this.mediaType;
    }

    public long contentLength() throws IOException {
        return this.body.length;
    }

    public void writeTo(BufferedSink bufferedSink) throws IOException {
        int byteSize = 102400;
        for (int byteIndex = 0; byteIndex < this.body.length; byteIndex += byteSize) {
            byteSize = Math.min(byteSize, this.body.length - byteIndex);
            RequestBody requestBody = this.getRequestBodyWithRange(byteIndex, byteSize);
            requestBody.writeTo(bufferedSink);
            bufferedSink.flush();
        }
    }

    private RequestBody getRequestBodyWithRange(int location, int size) {
        byte[] data = Arrays.copyOfRange(this.body, location, location + size);
        return RequestBody.create((byte[])data, (MediaType)this.contentType());
    }
}

