/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.common.AutoZone;
import com.qiniu.android.common.Zone;
import com.qiniu.android.http.ProxyConfiguration;
import com.qiniu.android.http.UrlConverter;
import com.qiniu.android.storage.KeyGenerator;
import com.qiniu.android.storage.Recorder;
import java.io.File;

public final class Configuration {
    public final Zone zone;
    public static final int BLOCK_SIZE = 0x400000;
    public final int chunkSize;
    public final int putThreshold;
    public final int retryMax;
    public final int retryInterval;
    public final int connectTimeout;
    public final int responseTimeout;
    public final boolean useHttps;
    public final boolean useConcurrentResumeUpload;
    public final int concurrentTaskCount;
    public final boolean allowBackupHost;
    public final Recorder recorder;
    public final KeyGenerator keyGen;
    public final ProxyConfiguration proxy;
    public final UrlConverter urlConverter;

    private Configuration(Builder builder) {
        this.chunkSize = builder.chunkSize;
        this.putThreshold = builder.putThreshold;
        this.connectTimeout = builder.connectTimeout;
        this.responseTimeout = builder.responseTimeout;
        this.recorder = builder.recorder;
        this.keyGen = this.getKeyGen(builder.keyGen);
        this.retryMax = builder.retryMax;
        this.retryInterval = builder.retryInterval;
        this.allowBackupHost = builder.allowBackupHost;
        this.proxy = builder.proxy;
        this.urlConverter = builder.urlConverter;
        this.useHttps = builder.useHttps;
        this.useConcurrentResumeUpload = builder.useConcurrentResumeUpload;
        this.concurrentTaskCount = builder.concurrentTaskCount;
        this.zone = builder.zone != null ? builder.zone : new AutoZone();
    }

    private KeyGenerator getKeyGen(KeyGenerator keyGen) {
        if (keyGen == null) {
            keyGen = new KeyGenerator(){

                @Override
                public String gen(String key, File file) {
                    return key + "_._" + new StringBuffer(file.getAbsolutePath()).reverse();
                }
            };
        }
        return keyGen;
    }

    public static class Builder {
        private Zone zone = null;
        private Recorder recorder = null;
        private KeyGenerator keyGen = null;
        private ProxyConfiguration proxy = null;
        private boolean useHttps = true;
        private int chunkSize = 0x200000;
        private int putThreshold = 0x400000;
        private int connectTimeout = 90;
        private int responseTimeout = 60;
        private int retryMax = 1;
        private int retryInterval = 500;
        private boolean allowBackupHost = true;
        private UrlConverter urlConverter = null;
        private boolean useConcurrentResumeUpload = false;
        private int concurrentTaskCount = 3;

        public Builder zone(Zone zone) {
            this.zone = zone;
            return this;
        }

        public Builder recorder(Recorder recorder) {
            this.recorder = recorder;
            return this;
        }

        public Builder recorder(Recorder recorder, KeyGenerator keyGen) {
            this.recorder = recorder;
            this.keyGen = keyGen;
            return this;
        }

        public Builder proxy(ProxyConfiguration proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder chunkSize(int size) {
            this.chunkSize = size;
            return this;
        }

        public Builder putThreshold(int size) {
            this.putThreshold = size;
            return this;
        }

        public Builder connectTimeout(int timeout) {
            this.connectTimeout = timeout;
            return this;
        }

        public Builder responseTimeout(int timeout) {
            this.responseTimeout = timeout;
            return this;
        }

        public Builder retryMax(int times) {
            this.retryMax = times;
            return this;
        }

        public Builder retryInterval(int retryInterval) {
            this.retryInterval = retryInterval;
            return this;
        }

        public Builder allowBackupHost(boolean isAllow) {
            this.allowBackupHost = isAllow;
            return this;
        }

        public Builder urlConverter(UrlConverter converter) {
            this.urlConverter = converter;
            return this;
        }

        public Builder useConcurrentResumeUpload(boolean useConcurrentResumeUpload) {
            this.useConcurrentResumeUpload = useConcurrentResumeUpload;
            return this;
        }

        public Builder concurrentTaskCount(int concurrentTaskCount) {
            this.concurrentTaskCount = concurrentTaskCount;
            return this;
        }

        public Builder useHttps(boolean useHttps) {
            this.useHttps = useHttps;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }
}

