/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import android.os.Looper;
import com.qiniu.android.storage.NetReadyHandler;
import com.qiniu.android.storage.UpCancellationSignal;
import com.qiniu.android.storage.UpProgressHandler;
import com.qiniu.android.utils.AndroidNetwork;
import com.qiniu.android.utils.LogUtil;
import java.util.HashMap;
import java.util.Map;

public final class UploadOptions {
    public final Map<String, String> params;
    public final String mimeType;
    public final boolean checkCrc;
    public final UpProgressHandler progressHandler;
    public final UpCancellationSignal cancellationSignal;
    public final NetReadyHandler netReadyHandler;

    public UploadOptions(Map<String, String> params, String mimeType, boolean checkCrc, UpProgressHandler progressHandler, UpCancellationSignal cancellationSignal) {
        this(params, mimeType, checkCrc, progressHandler, cancellationSignal, null);
    }

    public UploadOptions(Map<String, String> params, String mimeType, boolean checkCrc, UpProgressHandler progressHandler, UpCancellationSignal cancellationSignal, NetReadyHandler netReadyHandler) {
        int netReadyCheckTime = 6;
        try {
            String netCheckTime = params.get("netCheckTime");
            if (netCheckTime != null) {
                netReadyCheckTime = Integer.parseInt(netCheckTime);
            }
        }
        catch (Exception netCheckTime) {
            // empty catch block
        }
        this.params = UploadOptions.filterParam(params);
        this.mimeType = UploadOptions.mime(mimeType);
        this.checkCrc = checkCrc;
        this.progressHandler = progressHandler != null ? progressHandler : new UpProgressHandler(){

            @Override
            public void progress(String key, double percent) {
                LogUtil.d("" + percent);
            }
        };
        this.cancellationSignal = cancellationSignal != null ? cancellationSignal : new UpCancellationSignal(){

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
        final int finalNetReadyCheckTime = netReadyCheckTime;
        this.netReadyHandler = netReadyHandler != null ? netReadyHandler : new NetReadyHandler(){

            @Override
            public void waitReady() {
                if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                    return;
                }
                for (int i = 0; i < finalNetReadyCheckTime; ++i) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (!AndroidNetwork.isNetWorkReady()) continue;
                    return;
                }
            }
        };
    }

    private static Map<String, String> filterParam(Map<String, String> params) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (params == null) {
            return ret;
        }
        for (Map.Entry<String, String> i : params.entrySet()) {
            if (!i.getKey().startsWith("x:") || i.getValue() == null || i.getValue().equals("")) continue;
            ret.put(i.getKey(), i.getValue());
        }
        return ret;
    }

    public static UploadOptions defaultOptions() {
        return new UploadOptions(null, null, false, null, null);
    }

    private static String mime(String mimeType) {
        if (mimeType == null || mimeType.equals("")) {
            return "application/octet-stream";
        }
        return mimeType;
    }
}

