/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.utils;

import android.util.Log;

public class LogUtil {
    private static boolean showLog = true;
    private static int showLevel = 2;

    public static int v(String msg) {
        return LogUtil.println(2, null, msg, null);
    }

    public static int v(String tag, String msg) {
        return LogUtil.println(2, tag, msg, null);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return LogUtil.println(2, tag, msg, tr);
    }

    public static int d(String msg) {
        return LogUtil.println(3, null, msg, null);
    }

    public static int d(String tag, String msg) {
        return LogUtil.println(3, tag, msg, null);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return LogUtil.println(3, tag, msg, tr);
    }

    public static int i(String msg) {
        return LogUtil.println(4, null, msg, null);
    }

    public static int i(String tag, String msg) {
        return LogUtil.println(4, tag, msg, null);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return LogUtil.println(4, tag, msg, tr);
    }

    public static int w(String msg) {
        return LogUtil.println(5, null, msg, null);
    }

    public static int w(String tag, String msg) {
        return LogUtil.println(5, tag, msg, null);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return LogUtil.println(5, tag, msg, tr);
    }

    public static int w(String tag, Throwable tr) {
        return LogUtil.println(5, tag, null, tr);
    }

    public static int e(String msg) {
        return LogUtil.println(6, null, msg, null);
    }

    public static int e(String tag, String msg) {
        return LogUtil.println(6, tag, msg, null);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return LogUtil.println(6, tag, msg, tr);
    }

    private static int println(int logLevel, String tag, String msg, Throwable tr) {
        if (LogUtil.shouldLog(logLevel, tag, msg, tr)) {
            switch (logLevel) {
                case 2: {
                    if (tr == null) {
                        return Log.v((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg));
                    }
                    return Log.v((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg), (Throwable)tr);
                }
                case 3: {
                    if (tr == null) {
                        return Log.d((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg));
                    }
                    return Log.d((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg), (Throwable)tr);
                }
                case 4: {
                    if (tr == null) {
                        return Log.i((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg));
                    }
                    return Log.i((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg), (Throwable)tr);
                }
                case 5: {
                    if (tr == null) {
                        return Log.w((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg));
                    }
                    return Log.w((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg), (Throwable)tr);
                }
                case 6: {
                    if (tr == null) {
                        return Log.e((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg));
                    }
                    return Log.e((String)LogUtil.recreateLogTag(tag), (String)LogUtil.recreateLogMessage(msg), (Throwable)tr);
                }
            }
            return -1;
        }
        return -1;
    }

    private static boolean shouldLog(int logLevel, String tag, String msg, Throwable tr) {
        if (logLevel < showLevel || (msg == null || msg.length() == 0) && tr == null) {
            return false;
        }
        return showLog;
    }

    private static String recreateLogTag(String tag) {
        String tagp = tag != null ? tag + ":" : "";
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        if (elements.length > 5 && elements[5] != null) {
            String fileName = elements[5].getFileName() != null ? elements[5].getFileName() : "?";
            int lineNumber = elements[5].getLineNumber();
            return "[QiNiu:" + tagp + fileName + ":" + lineNumber + "]";
        }
        return "[QiNiu:]" + tagp + "]";
    }

    private static String recreateLogMessage(String msg) {
        return msg != null ? msg : "";
    }
}

