/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.request;

import com.qiniu.android.collect.ReportItem;
import com.qiniu.android.collect.UploadInfoReporter;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.DnsPrefetcher;
import com.qiniu.android.http.metrics.UploadSingleRequestMetrics;
import com.qiniu.android.http.request.IRequestClient;
import com.qiniu.android.http.request.Request;
import com.qiniu.android.http.request.UploadRequestInfo;
import com.qiniu.android.http.request.UploadRequestState;
import com.qiniu.android.http.request.handler.CheckCancelHandler;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.http.request.handler.RequestShouldRetryHandler;
import com.qiniu.android.http.request.httpclient.SystemHttpClient;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.Utils;
import java.util.ArrayList;
import org.json.JSONObject;

class HttpSingleRequest {
    private int currentRetryTime;
    private final Configuration config;
    private final UploadOptions uploadOption;
    private final UpToken token;
    private final UploadRequestInfo requestInfo;
    private final UploadRequestState requestState;
    private ArrayList<UploadSingleRequestMetrics> requestMetricsList;
    private IRequestClient client;

    HttpSingleRequest(Configuration config, UploadOptions uploadOption, UpToken token, UploadRequestInfo requestInfo, UploadRequestState requestState) {
        this.config = config;
        this.uploadOption = uploadOption;
        this.token = token;
        this.requestInfo = requestInfo;
        this.requestState = requestState;
        this.currentRetryTime = 1;
    }

    void request(Request request, boolean isAsync, boolean toSkipDns, RequestShouldRetryHandler shouldRetryHandler, RequestProgressHandler progressHandler, RequestCompleteHandler completeHandler) {
        this.currentRetryTime = 1;
        this.requestMetricsList = new ArrayList();
        this.retryRequest(request, isAsync, toSkipDns, shouldRetryHandler, progressHandler, completeHandler);
    }

    private void retryRequest(final Request request, final boolean isAsync, final boolean toSkipDns, final RequestShouldRetryHandler shouldRetryHandler, final RequestProgressHandler progressHandler, final RequestCompleteHandler completeHandler) {
        this.client = toSkipDns ? new SystemHttpClient() : new SystemHttpClient();
        final CheckCancelHandler checkCancelHandler = new CheckCancelHandler(){

            @Override
            public boolean checkCancel() {
                boolean isCancelled = HttpSingleRequest.this.requestState.isUserCancel();
                if (!isCancelled && ((HttpSingleRequest)HttpSingleRequest.this).uploadOption.cancellationSignal != null) {
                    isCancelled = ((HttpSingleRequest)HttpSingleRequest.this).uploadOption.cancellationSignal.isCancelled();
                }
                return isCancelled;
            }
        };
        this.client.request(request, isAsync, this.config.proxy, new IRequestClient.RequestClientProgress(){

            @Override
            public void progress(long totalBytesWritten, long totalBytesExpectedToWrite) {
                if (checkCancelHandler.checkCancel()) {
                    HttpSingleRequest.this.requestState.setUserCancel(true);
                    if (HttpSingleRequest.this.client != null) {
                        HttpSingleRequest.this.client.cancel();
                    }
                } else if (progressHandler != null) {
                    progressHandler.progress(totalBytesWritten, totalBytesExpectedToWrite);
                }
            }
        }, new IRequestClient.RequestClientCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadSingleRequestMetrics metrics, JSONObject response) {
                if (metrics != null) {
                    HttpSingleRequest.this.requestMetricsList.add(metrics);
                }
                if (shouldRetryHandler != null && shouldRetryHandler.shouldRetry(responseInfo, response) && HttpSingleRequest.this.currentRetryTime < ((HttpSingleRequest)HttpSingleRequest.this).config.retryMax && responseInfo.couldHostRetry()) {
                    HttpSingleRequest.this.currentRetryTime += 1;
                    try {
                        Thread.sleep(((HttpSingleRequest)HttpSingleRequest.this).config.retryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    HttpSingleRequest.this.retryRequest(request, isAsync, toSkipDns, shouldRetryHandler, progressHandler, completeHandler);
                } else {
                    HttpSingleRequest.this.completeAction(request, responseInfo, response, metrics, completeHandler);
                }
            }
        });
    }

    private synchronized void completeAction(Request request, ResponseInfo responseInfo, JSONObject response, UploadSingleRequestMetrics requestMetrics, RequestCompleteHandler completeHandler) {
        if (this.client == null) {
            return;
        }
        this.client = null;
        if (completeHandler != null) {
            completeHandler.complete(responseInfo, this.requestMetricsList, response);
        }
        this.reportRequest(responseInfo, request, requestMetrics);
    }

    private void reportRequest(ResponseInfo responseInfo, Request request, UploadSingleRequestMetrics requestMetrics) {
        if (this.requestInfo == null || !this.requestInfo.shouldReportRequestLog() || requestMetrics == null) {
            return;
        }
        long currentTimestamp = Utils.currentTimestamp();
        ReportItem item = new ReportItem();
        item.setReport("request", "log_type");
        item.setReport(currentTimestamp / 1000L, "up_time");
        item.setReport(ReportItem.requestReportStatusCode(responseInfo), "status_code");
        item.setReport(responseInfo != null ? responseInfo.reqId : null, "req_id");
        item.setReport(request != null ? request.host : null, "host");
        item.setReport(requestMetrics.remoteAddress, "remote_ip");
        item.setReport(requestMetrics.remotePort, "port");
        item.setReport(this.requestInfo.bucket, "target_bucket");
        item.setReport(this.requestInfo.key, "target_key");
        item.setReport(requestMetrics.totalElapsedTime(), "total_elapsed_time");
        item.setReport(requestMetrics.totalDnsTime(), "dns_elapsed_time");
        item.setReport(requestMetrics.totalConnectTime(), "connect_elapsed_time");
        item.setReport(requestMetrics.totalSecureConnectTime(), "tls_connect_elapsed_time");
        item.setReport(requestMetrics.totalRequestTime(), "request_elapsed_time");
        item.setReport(requestMetrics.totalWaitTime(), "wait_elapsed_time");
        item.setReport(requestMetrics.totalWaitTime(), "response_elapsed_time");
        item.setReport(requestMetrics.totalResponseTime(), "response_elapsed_time");
        item.setReport(this.requestInfo.fileOffset, "file_offset");
        item.setReport(requestMetrics.bytesSend(), "bytes_sent");
        item.setReport(requestMetrics.totalBytes(), "bytes_total");
        item.setReport(Utils.getCurrentProcessID(), "pid");
        item.setReport(Utils.getCurrentThreadID(), "tid");
        item.setReport(this.requestInfo.targetRegionId, "target_region_id");
        item.setReport(this.requestInfo.currentRegionId, "current_region_id");
        String errorType = ReportItem.requestReportErrorType(responseInfo);
        item.setReport(errorType, "error_type");
        String errorDesc = null;
        if (responseInfo != null && errorType != null) {
            errorDesc = responseInfo.error != null ? responseInfo.error : responseInfo.message;
        }
        item.setReport(errorDesc, "error_description");
        item.setReport(this.requestInfo.requestType, "up_type");
        item.setReport(Utils.systemName(), "os_name");
        item.setReport(Utils.systemVersion(), "os_version");
        item.setReport(Utils.sdkLanguage(), "sdk_name");
        item.setReport(Utils.sdkVerion(), "sdk_version");
        item.setReport(currentTimestamp, "client_time");
        item.setReport(Utils.getCurrentNetworkType(), "network_type");
        item.setReport(Utils.getCurrentSignalStrength(), "signal_strength");
        item.setReport(request.uploadServer.getSource(), "prefetched_dns_source");
        if (request.uploadServer.getIpPrefetchedTime() != null) {
            Long prefetchTime = request.uploadServer.getIpPrefetchedTime() - currentTimestamp;
            item.setReport(prefetchTime, "prefetched_before");
        }
        item.setReport(DnsPrefetcher.getInstance().lastPrefetchErrorMessage, "prefetched_error_message");
        UploadInfoReporter.getInstance().report(item, this.token.token);
    }

    static interface RequestCompleteHandler {
        public void complete(ResponseInfo var1, ArrayList<UploadSingleRequestMetrics> var2, JSONObject var3);
    }
}

