/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.serverRegion;

import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.DnsPrefetcher;
import com.qiniu.android.http.dns.IDnsNetworkAddress;
import com.qiniu.android.http.request.IUploadRegion;
import com.qiniu.android.http.request.IUploadServer;
import com.qiniu.android.http.serverRegion.UploadServer;
import com.qiniu.android.http.serverRegion.UploadServerFreezeManager;
import com.qiniu.android.storage.GlobalConfiguration;
import com.qiniu.android.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UploadDomainRegion
implements IUploadRegion {
    private boolean hasGot;
    private boolean isAllFrozen;
    private UploadServerFreezeManager partialFreezeManager = new UploadServerFreezeManager();
    private ArrayList<String> domainHostList;
    private HashMap<String, UploadServerDomain> domainHashMap;
    private ArrayList<String> oldDomainHostList;
    private HashMap<String, UploadServerDomain> oldDomainHashMap;
    private ZoneInfo zoneInfo;

    @Override
    public boolean isValid() {
        return !this.isAllFrozen && (this.domainHostList.size() > 0 || this.oldDomainHostList.size() > 0);
    }

    @Override
    public ZoneInfo getZoneInfo() {
        return this.zoneInfo;
    }

    @Override
    public void setupRegionData(ZoneInfo zoneInfo) {
        if (zoneInfo == null) {
            return;
        }
        this.zoneInfo = zoneInfo;
        this.isAllFrozen = false;
        ArrayList<String> domainHostList = new ArrayList<String>();
        if (zoneInfo.domains != null) {
            domainHostList.addAll(zoneInfo.domains);
        }
        this.domainHostList = domainHostList;
        this.domainHashMap = this.createDomainDictionary(domainHostList);
        ArrayList<String> oldDomainHostList = new ArrayList<String>();
        if (zoneInfo.old_domains != null) {
            oldDomainHostList.addAll(zoneInfo.old_domains);
        }
        this.oldDomainHostList = oldDomainHostList;
        this.oldDomainHashMap = this.createDomainDictionary(oldDomainHostList);
    }

    @Override
    public IUploadServer getNextServer(boolean isOldServer, ResponseInfo responseInfo, IUploadServer freezeServer) {
        UploadServerDomain domain;
        if (this.isAllFrozen) {
            return null;
        }
        this.freezeServerIfNeed(responseInfo, freezeServer);
        ArrayList<String> hostList = isOldServer ? this.oldDomainHostList : this.domainHostList;
        HashMap<String, UploadServerDomain> domainInfo = isOldServer ? this.oldDomainHashMap : this.domainHashMap;
        IUploadServer server = null;
        for (String host : hostList) {
            domain = domainInfo.get(host);
            if (domain != null) {
                server = domain.getServer(new UploadServerFreezeManager[]{this.partialFreezeManager, UploadServerFreezeManager.getInstance()});
            }
            if (server == null) continue;
            break;
        }
        if (server == null && !this.hasGot && hostList.size() > 0) {
            String host;
            int index = (int)(Math.random() * (double)hostList.size());
            host = hostList.get(index);
            domain = domainInfo.get(host);
            if (domain != null) {
                server = domain.getOneServer();
            }
            this.unfreezeServer(server);
        }
        this.hasGot = true;
        if (server == null) {
            this.isAllFrozen = true;
        }
        return server;
    }

    private void freezeServerIfNeed(ResponseInfo responseInfo, IUploadServer freezeServer) {
        UploadServerDomain domain;
        if (responseInfo == null || freezeServer == null || freezeServer.getServerId() == null) {
            return;
        }
        if (!responseInfo.canConnectToHost() || responseInfo.isHostUnavailable()) {
            domain = null;
            domain = this.domainHashMap.get(freezeServer.getServerId());
            if (domain != null) {
                domain.freeze(freezeServer.getIp(), this.partialFreezeManager, GlobalConfiguration.getInstance().partialHostFrozenTime);
            }
            if ((domain = this.oldDomainHashMap.get(freezeServer.getServerId())) != null) {
                domain.freeze(freezeServer.getIp(), this.partialFreezeManager, GlobalConfiguration.getInstance().partialHostFrozenTime);
            }
        }
        if (responseInfo.isHostUnavailable()) {
            domain = null;
            domain = this.domainHashMap.get(freezeServer.getServerId());
            if (domain != null) {
                domain.freeze(freezeServer.getIp(), UploadServerFreezeManager.getInstance(), GlobalConfiguration.getInstance().globalHostFrozenTime);
            }
            if ((domain = this.oldDomainHashMap.get(freezeServer.getServerId())) != null) {
                domain.freeze(freezeServer.getIp(), UploadServerFreezeManager.getInstance(), GlobalConfiguration.getInstance().globalHostFrozenTime);
            }
        }
    }

    private void unfreezeServer(IUploadServer freezeServer) {
        if (freezeServer == null || freezeServer.getServerId() == null) {
            return;
        }
        UploadServerDomain domain = null;
        domain = this.domainHashMap.get(freezeServer.getServerId());
        if (domain != null) {
            domain.unfreeze(freezeServer.getIp(), new UploadServerFreezeManager[]{this.partialFreezeManager, UploadServerFreezeManager.getInstance()});
        }
        if ((domain = this.oldDomainHashMap.get(freezeServer.getServerId())) != null) {
            domain.unfreeze(freezeServer.getIp(), new UploadServerFreezeManager[]{this.partialFreezeManager, UploadServerFreezeManager.getInstance()});
        }
    }

    private HashMap<String, UploadServerDomain> createDomainDictionary(List<String> hosts) {
        HashMap<String, UploadServerDomain> domainHashMap = new HashMap<String, UploadServerDomain>();
        for (int i = 0; i < hosts.size(); ++i) {
            String host = hosts.get(i);
            UploadServerDomain domain = new UploadServerDomain(host);
            domainHashMap.put(host, domain);
        }
        return domainHashMap;
    }

    private static class UploadServerDomain {
        private boolean isAllFrozen = false;
        protected final String host;
        protected ArrayList<UploadIpGroup> ipGroupList = new ArrayList();

        protected UploadServerDomain(String host) {
            this.host = host;
        }

        protected IUploadServer getServer(UploadServerFreezeManager[] freezeManagerList) {
            if (this.isAllFrozen || this.host == null || this.host.length() == 0) {
                return null;
            }
            if (this.ipGroupList == null || this.ipGroupList.size() == 0) {
                this.createIpGroupList();
            }
            if (this.ipGroupList != null && this.ipGroupList.size() > 0) {
                UploadServer server = null;
                for (UploadIpGroup ipGroup : this.ipGroupList) {
                    if (ipGroup.groupType == null || this.isGroupFrozenByFreezeManagers(ipGroup.groupType, freezeManagerList)) continue;
                    IDnsNetworkAddress networkAddress = ipGroup.getNetworkAddress();
                    server = new UploadServer(this.host, this.host, networkAddress.getIpValue(), networkAddress.getSourceValue(), networkAddress.getTimestampValue());
                    break;
                }
                if (server == null) {
                    this.isAllFrozen = true;
                }
                return server;
            }
            String groupType = Utils.getIpType(null, this.host);
            if (groupType != null && !this.isGroupFrozenByFreezeManagers(groupType, freezeManagerList)) {
                return new UploadServer(this.host, this.host, null, null, null);
            }
            this.isAllFrozen = true;
            return null;
        }

        protected boolean isGroupFrozenByFreezeManagers(String groupType, UploadServerFreezeManager[] freezeManagerList) {
            UploadServerFreezeManager freezeManager;
            if (groupType == null) {
                return true;
            }
            if (freezeManagerList == null || freezeManagerList.length == 0) {
                return false;
            }
            boolean isFrozen = false;
            UploadServerFreezeManager[] uploadServerFreezeManagerArray = freezeManagerList;
            int n = uploadServerFreezeManagerArray.length;
            for (int i = 0; i < n && !(isFrozen = (freezeManager = uploadServerFreezeManagerArray[i]).isFreezeHost(this.host, groupType)); ++i) {
            }
            return isFrozen;
        }

        protected UploadServer getOneServer() {
            if (this.host == null || this.host.length() == 0) {
                return null;
            }
            if (this.ipGroupList != null && this.ipGroupList.size() > 0) {
                int index = (int)(Math.random() * (double)this.ipGroupList.size());
                UploadIpGroup ipGroup = this.ipGroupList.get(index);
                IDnsNetworkAddress inetAddress = ipGroup.getNetworkAddress();
                UploadServer server = new UploadServer(this.host, this.host, inetAddress.getIpValue(), inetAddress.getSourceValue(), inetAddress.getTimestampValue());
                return server;
            }
            return new UploadServer(this.host, this.host, null, null, null);
        }

        private synchronized void createIpGroupList() {
            if (this.ipGroupList != null && this.ipGroupList.size() > 0) {
                return;
            }
            List<IDnsNetworkAddress> networkAddresses = DnsPrefetcher.getInstance().getInetAddressByHost(this.host);
            if (networkAddresses == null || networkAddresses.size() == 0) {
                return;
            }
            HashMap<String, ArrayList<IDnsNetworkAddress>> ipGroupInfo = new HashMap<String, ArrayList<IDnsNetworkAddress>>();
            for (IDnsNetworkAddress networkAddress : networkAddresses) {
                String groupType;
                String ipValue = networkAddress.getIpValue();
                if (ipValue == null || (groupType = Utils.getIpType(ipValue, this.host)) == null) continue;
                ArrayList<IDnsNetworkAddress> groupNetworkAddresses = (ArrayList<IDnsNetworkAddress>)ipGroupInfo.get(groupType);
                if (groupNetworkAddresses == null) {
                    groupNetworkAddresses = new ArrayList<IDnsNetworkAddress>();
                }
                groupNetworkAddresses.add(networkAddress);
                ipGroupInfo.put(groupType, groupNetworkAddresses);
            }
            ArrayList<UploadIpGroup> ipGroupList = new ArrayList<UploadIpGroup>();
            for (String groupType : ipGroupInfo.keySet()) {
                ArrayList addresses = (ArrayList)ipGroupInfo.get(groupType);
                UploadIpGroup ipGroup = new UploadIpGroup(groupType, addresses);
                ipGroupList.add(ipGroup);
            }
            this.ipGroupList = ipGroupList;
        }

        protected void freeze(String ip, UploadServerFreezeManager freezeManager, int frozenTime) {
            if (freezeManager == null) {
                return;
            }
            freezeManager.freezeHost(this.host, Utils.getIpType(ip, this.host), frozenTime);
        }

        protected void unfreeze(String ip, UploadServerFreezeManager[] freezeManagerList) {
            if (freezeManagerList == null || freezeManagerList.length == 0) {
                return;
            }
            for (UploadServerFreezeManager freezeManager : freezeManagerList) {
                freezeManager.unfreezeHost(this.host, Utils.getIpType(ip, this.host));
            }
        }
    }

    private static class UploadIpGroup {
        private final String groupType;
        private final ArrayList<IDnsNetworkAddress> addressList;

        protected UploadIpGroup(String groupType, ArrayList<IDnsNetworkAddress> addressList) {
            this.groupType = groupType;
            this.addressList = addressList;
        }

        protected IDnsNetworkAddress getNetworkAddress() {
            if (this.addressList == null || this.addressList.size() == 0) {
                return null;
            }
            int index = (int)(Math.random() * (double)this.addressList.size());
            return this.addressList.get(index);
        }
    }
}

