/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.serverRegion;

import com.qiniu.android.utils.Utils;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;

public class UploadServerFreezeManager {
    private ConcurrentHashMap<String, UploadServerFreezeItem> frozenInfo = new ConcurrentHashMap();
    private static final UploadServerFreezeManager manager = new UploadServerFreezeManager();

    public static UploadServerFreezeManager getInstance() {
        return manager;
    }

    public boolean isFreezeHost(String host, String type) {
        if (host == null || host.length() == 0) {
            return true;
        }
        boolean isFrozen = true;
        String infoKey = this.getItemInfoKey(host, type);
        UploadServerFreezeItem item = this.frozenInfo.get(infoKey);
        if (item == null || !item.isFrozenByDate(new Date())) {
            isFrozen = false;
        }
        return isFrozen;
    }

    public void freezeHost(String host, String type, int frozenTime) {
        if (host == null || host.length() == 0) {
            return;
        }
        String infoKey = this.getItemInfoKey(host, type);
        UploadServerFreezeItem item = this.frozenInfo.get(infoKey);
        if (item == null) {
            item = new UploadServerFreezeItem(host, type);
            this.frozenInfo.put(infoKey, item);
        }
        item.freeze(frozenTime);
    }

    public void unfreezeHost(String host, String type) {
        if (host == null || host.length() == 0) {
            return;
        }
        String infoKey = this.getItemInfoKey(host, type);
        if (infoKey != null) {
            this.frozenInfo.remove(infoKey);
        }
    }

    private String getItemInfoKey(String host, String type) {
        return String.format("%s:%s", host != null ? host : "none", type != null ? type : "none");
    }

    private static class UploadServerFreezeItem {
        protected final String host;
        protected final String type;
        protected Date freezeDate;

        protected UploadServerFreezeItem(String host, String type) {
            this.host = host;
            this.type = type;
        }

        protected synchronized boolean isFrozenByDate(Date date) {
            boolean isFrozen = true;
            if (this.freezeDate == null || this.freezeDate.getTime() < date.getTime()) {
                isFrozen = false;
            }
            return isFrozen;
        }

        protected synchronized void freeze(int frozenTime) {
            this.freezeDate = new Date(Utils.currentTimestamp() + (long)(frozenTime * 1000));
        }
    }
}

