/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.collect.ReportItem;
import com.qiniu.android.collect.UploadInfoReporter;
import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.IUploadRegion;
import com.qiniu.android.http.request.UploadFileInfo;
import com.qiniu.android.storage.BaseUpload;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.json.JSONException;
import org.json.JSONObject;

abstract class PartsUpload
extends BaseUpload {
    private static final String kRecordFileInfoKey = "recordFileInfo";
    private static final String kRecordZoneInfoKey = "recordZoneInfo";
    protected static long blockSize = 0x400000L;
    protected Long chunkSize;
    private Long recoveredFrom;
    private UploadFileInfo uploadFileInfo;
    private RandomAccessFile randomAccessFile;

    protected PartsUpload(File file, String key, UpToken token, UploadOptions option, Configuration config, Recorder recorder, String recorderKey, BaseUpload.UpTaskCompletionHandler completionHandler) {
        super(file, key, token, option, config, recorder, recorderKey, completionHandler);
        RandomAccessFile randomAccessFile = null;
        if (file != null) {
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        this.randomAccessFile = randomAccessFile;
    }

    protected UploadFileInfo getUploadFileInfo() {
        return this.uploadFileInfo;
    }

    private void closeUploadFileInfo() {
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected RandomAccessFile getRandomAccessFile() {
        return this.randomAccessFile;
    }

    @Override
    protected int prepareToUpload() {
        int code = super.prepareToUpload();
        if (code != 0) {
            return code;
        }
        this.recoverUploadInfoFromRecord();
        if (this.uploadFileInfo == null) {
            this.uploadFileInfo = new UploadFileInfo(this.file.length(), blockSize, this.getUploadChunkSize(), this.file.lastModified());
        }
        if (this.randomAccessFile == null) {
            code = -7;
        }
        return code;
    }

    @Override
    protected boolean switchRegionAndUpload() {
        boolean isSwitched;
        this.reportBlock();
        if (this.uploadFileInfo != null) {
            this.uploadFileInfo.clearUploadState();
        }
        if (isSwitched = super.switchRegionAndUpload()) {
            this.removeUploadInfoRecord();
        }
        return isSwitched;
    }

    @Override
    protected void completeAction(ResponseInfo responseInfo, JSONObject response) {
        this.reportBlock();
        this.closeUploadFileInfo();
        super.completeAction(responseInfo, response);
        this.uploadFileInfo = null;
    }

    protected void recordUploadInfo() {
        String key = this.recorderKey;
        if (this.recorder == null || key == null || key.length() == 0) {
            return;
        }
        JSONObject zoneInfo = null;
        JSONObject fileInfo = null;
        IUploadRegion currentRegion = this.getCurrentRegion();
        if (currentRegion != null && currentRegion.getZoneInfo() != null) {
            zoneInfo = currentRegion.getZoneInfo().detailInfo;
        }
        if (this.uploadFileInfo != null) {
            fileInfo = this.uploadFileInfo.toJsonObject();
        }
        if (zoneInfo != null && fileInfo != null) {
            JSONObject info = new JSONObject();
            try {
                info.put(kRecordZoneInfoKey, (Object)zoneInfo);
                info.put(kRecordFileInfoKey, (Object)fileInfo);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.recorder.set(key, info.toString().getBytes());
        }
    }

    protected void removeUploadInfoRecord() {
        this.recoveredFrom = null;
        if (this.uploadFileInfo != null) {
            this.uploadFileInfo.clearUploadState();
        }
        if (this.recorder != null && this.recorderKey != null) {
            this.recorder.del(this.recorderKey);
        }
    }

    private void recoverUploadInfoFromRecord() {
        String key = this.recorderKey;
        if (this.recorder == null || key == null || key.length() == 0) {
            return;
        }
        byte[] data = this.recorder.get(key);
        if (data == null) {
            return;
        }
        try {
            JSONObject info = new JSONObject(new String(data));
            ZoneInfo zoneInfo = ZoneInfo.buildFromJson(info.getJSONObject(kRecordZoneInfoKey));
            UploadFileInfo fileInfo = UploadFileInfo.fileFromJson(info.getJSONObject(kRecordFileInfoKey));
            if (zoneInfo != null && fileInfo != null && fileInfo.size == this.file.length() && fileInfo.modifyTime == this.file.lastModified() && fileInfo.uploadBlocks != null && fileInfo.uploadBlocks.size() > 0 && fileInfo.uploadBlocks.get((int)0).uploadDataList != null && fileInfo.uploadBlocks.get((int)0).uploadDataList.size() > 0 && fileInfo.uploadBlocks.get((int)0).uploadDataList.get((int)0).size == this.getUploadChunkSize()) {
                this.insertRegionAtFirstByZoneInfo(zoneInfo);
                this.uploadFileInfo = fileInfo;
                this.recoveredFrom = (long)(fileInfo.progress() * (double)fileInfo.size);
            } else {
                this.recorder.del(key);
            }
        }
        catch (Exception e) {
            this.recorder.del(key);
        }
    }

    private long getUploadChunkSize() {
        if (this.chunkSize != null) {
            return this.chunkSize;
        }
        return this.config.chunkSize;
    }

    private void reportBlock() {
        UploadRegionRequestMetrics metrics = this.getCurrentRegionRequestMetrics();
        if (metrics == null) {
            metrics = new UploadRegionRequestMetrics(null);
        }
        String currentZoneRegionId = null;
        if (this.getCurrentRegion() != null && this.getCurrentRegion().getZoneInfo() != null && this.getCurrentRegion().getZoneInfo().regionId != null) {
            currentZoneRegionId = this.getCurrentRegion().getZoneInfo().regionId;
        }
        String targetZoneRegionId = null;
        if (this.getTargetRegion() != null && this.getTargetRegion().getZoneInfo() != null && this.getTargetRegion().getZoneInfo().regionId != null) {
            targetZoneRegionId = this.getTargetRegion().getZoneInfo().regionId;
        }
        ReportItem item = new ReportItem();
        item.setReport("block", "log_type");
        item.setReport(Utils.currentTimestamp() / 1000L, "up_time");
        item.setReport(currentZoneRegionId, "target_region_id");
        item.setReport(targetZoneRegionId, "current_region_id");
        item.setReport(metrics.totalElapsedTime(), "total_elapsed_time");
        item.setReport(metrics.bytesSend(), "bytes_sent");
        item.setReport(this.recoveredFrom, "recovered_from");
        item.setReport(this.file.length(), "file_size");
        item.setReport(Utils.getCurrentProcessID(), "pid");
        item.setReport(Utils.getCurrentThreadID(), "tid");
        item.setReport(1, "up_api_version");
        item.setReport(Utils.currentTimestamp(), "client_time");
        UploadInfoReporter.getInstance().report(item, this.token.token);
    }
}

