/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.collect.ReportItem;
import com.qiniu.android.collect.UploadInfoReporter;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.DnsPrefetchTransaction;
import com.qiniu.android.http.metrics.UploadTaskMetrics;
import com.qiniu.android.storage.BaseUpload;
import com.qiniu.android.storage.ConcurrentResumeUpload;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.FormUpload;
import com.qiniu.android.storage.KeyGenerator;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.ResumeUpload;
import com.qiniu.android.storage.UpCompletionHandler;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.Utils;
import com.qiniu.android.utils.Wait;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.json.JSONObject;

public class UploadManager {
    private final Configuration config;

    public UploadManager(Recorder recorder) {
        this(recorder, null);
    }

    public UploadManager(Recorder recorder, KeyGenerator keyGen) {
        this(new Configuration.Builder().recorder(recorder, keyGen).build());
    }

    public UploadManager() {
        this(new Configuration.Builder().build());
    }

    public UploadManager(Configuration config) {
        this.config = config;
        DnsPrefetchTransaction.addDnsLocalLoadTransaction();
        DnsPrefetchTransaction.setDnsCheckWhetherCachedValidTransactionAction();
    }

    public void put(byte[] data, String key, String token, UpCompletionHandler complete, UploadOptions options) {
        if (this.checkAndNotifyError(key, token, data, complete)) {
            return;
        }
        this.putData(data, null, key, token, options, complete);
    }

    public void put(String filePath, String key, String token, UpCompletionHandler completionHandler, UploadOptions options) {
        if (this.checkAndNotifyError(key, token, filePath, completionHandler)) {
            return;
        }
        this.put(new File(filePath), key, token, completionHandler, options);
    }

    public void put(File file, String key, String token, UpCompletionHandler completionHandler, UploadOptions options) {
        if (this.checkAndNotifyError(key, token, file, completionHandler)) {
            return;
        }
        this.putFile(file, key, token, options, completionHandler);
    }

    public ResponseInfo syncPut(byte[] data, String key, String token, UploadOptions options) {
        final ArrayList responseInfos = new ArrayList();
        final Wait wait = new Wait();
        UpCompletionHandler completionHandler = new UpCompletionHandler(){

            @Override
            public void complete(String key, ResponseInfo info, JSONObject response) {
                if (info != null) {
                    responseInfos.add(info);
                }
                wait.stopWait();
            }
        };
        if (!this.checkAndNotifyError(key, token, data, completionHandler)) {
            this.putData(data, null, key, token, options, completionHandler);
        }
        wait.startWait();
        if (responseInfos.size() > 0) {
            return (ResponseInfo)responseInfos.get(0);
        }
        return null;
    }

    public ResponseInfo syncPut(File file, String key, String token, UploadOptions options) {
        final ArrayList responseInfos = new ArrayList();
        final Wait wait = new Wait();
        UpCompletionHandler completionHandler = new UpCompletionHandler(){

            @Override
            public void complete(String key, ResponseInfo info, JSONObject response) {
                if (info != null) {
                    responseInfos.add(info);
                }
                wait.stopWait();
            }
        };
        if (!this.checkAndNotifyError(key, token, file, completionHandler)) {
            this.putFile(file, key, token, options, completionHandler);
        }
        wait.startWait();
        if (responseInfos.size() > 0) {
            return (ResponseInfo)responseInfos.get(0);
        }
        return null;
    }

    public ResponseInfo syncPut(String file, String key, String token, UploadOptions options) {
        return this.syncPut(new File(file), key, token, options);
    }

    private void putData(byte[] data, String fileName, String key, final String token, UploadOptions option, final UpCompletionHandler completionHandler) {
        UpToken t = UpToken.parse(token);
        if (t == null) {
            ResponseInfo info = ResponseInfo.invalidToken("invalid token");
            this.completeAction(token, key, info, null, null, completionHandler);
            return;
        }
        DnsPrefetchTransaction.addDnsCheckAndPrefetchTransaction(this.config.zone, t);
        BaseUpload.UpTaskCompletionHandler completionHandlerP = new BaseUpload.UpTaskCompletionHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, String key, UploadTaskMetrics requestMetrics, JSONObject response) {
                UploadManager.this.completeAction(token, key, responseInfo, response, requestMetrics, completionHandler);
            }
        };
        FormUpload up = new FormUpload(data, key, fileName, t, option, this.config, completionHandlerP);
        AsyncRun.runInBack(up);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putFile(File file, String key, final String token, UploadOptions option, final UpCompletionHandler completionHandler) {
        UpToken t = UpToken.parse(token);
        if (t == null) {
            ResponseInfo info = ResponseInfo.invalidToken("invalid token");
            this.completeAction(token, key, info, null, null, completionHandler);
            return;
        }
        DnsPrefetchTransaction.addDnsCheckAndPrefetchTransaction(this.config.zone, t);
        if (file.length() <= (long)this.config.putThreshold) {
            ResponseInfo errorInfo = null;
            byte[] data = new byte[(int)file.length()];
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                randomAccessFile.read(data);
            }
            catch (FileNotFoundException e) {
                errorInfo = ResponseInfo.localIOError("get upload file data error");
            }
            catch (IOException e) {
                errorInfo = ResponseInfo.localIOError("get upload file data error");
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (errorInfo == null) {
                this.putData(data, file.getName(), key, token, option, completionHandler);
            } else {
                this.completeAction(token, key, errorInfo, null, null, completionHandler);
            }
            return;
        }
        String recorderKey = key;
        if (this.config.recorder != null && this.config.keyGen != null) {
            recorderKey = this.config.keyGen.gen(key, file);
        }
        BaseUpload.UpTaskCompletionHandler completionHandlerP = new BaseUpload.UpTaskCompletionHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, String key, UploadTaskMetrics requestMetrics, JSONObject response) {
                UploadManager.this.completeAction(token, key, responseInfo, response, requestMetrics, completionHandler);
            }
        };
        if (this.config.useConcurrentResumeUpload) {
            ConcurrentResumeUpload up = new ConcurrentResumeUpload(file, recorderKey, t, option, this.config, this.config.recorder, key, completionHandlerP);
            AsyncRun.runInBack(up);
        } else {
            ResumeUpload up = new ResumeUpload(file, key, t, option, this.config, this.config.recorder, recorderKey, completionHandlerP);
            AsyncRun.runInBack(up);
        }
    }

    private boolean checkAndNotifyError(String key, String token, Object input, UpCompletionHandler completionHandler) {
        if (completionHandler == null) {
            throw new NullPointerException("complete handler is null");
        }
        ResponseInfo responseInfo = null;
        if (input == null) {
            responseInfo = ResponseInfo.zeroSize("no input data");
        } else if (input instanceof byte[] && ((byte[])input).length == 0) {
            responseInfo = ResponseInfo.zeroSize("no input data");
        } else if (input instanceof File && ((File)input).length() == 0L) {
            responseInfo = ResponseInfo.zeroSize("file is empty");
        } else if (token == null || token.length() == 0) {
            responseInfo = ResponseInfo.invalidToken("no token");
        }
        if (responseInfo != null) {
            this.completeAction(token, key, responseInfo, responseInfo.response, null, completionHandler);
            return true;
        }
        return false;
    }

    private void completeAction(String token, final String key, final ResponseInfo responseInfo, final JSONObject response, UploadTaskMetrics taskMetrics, final UpCompletionHandler completionHandler) {
        this.reportQuality(key, responseInfo, taskMetrics, token);
        if (completionHandler != null) {
            final Wait wait = new Wait();
            AsyncRun.runInMain(new Runnable(){

                @Override
                public void run() {
                    completionHandler.complete(key, responseInfo, response);
                    wait.stopWait();
                }
            });
            wait.startWait();
        }
    }

    private void reportQuality(String key, ResponseInfo responseInfo, UploadTaskMetrics taskMetrics, String token) {
        UpToken upToken = UpToken.parse(token);
        UploadTaskMetrics taskMetricsP = taskMetrics != null ? taskMetrics : new UploadTaskMetrics(null);
        ReportItem item = new ReportItem();
        item.setReport("quality", "log_type");
        item.setReport(Utils.currentTimestamp() / 1000L, "up_time");
        item.setReport(ReportItem.qualityResult(responseInfo), "result");
        item.setReport(key, "target_key");
        item.setReport(upToken != null ? upToken.bucket : null, "target_bucket");
        item.setReport(taskMetricsP.totalElapsedTime(), "total_elapsed_time");
        item.setReport(taskMetricsP.requestCount(), "requests_count");
        item.setReport(taskMetricsP.regionCount(), "regions_count");
        item.setReport(taskMetricsP.bytesSend(), "bytes_sent");
        UploadInfoReporter.getInstance().report(item, token);
    }
}

