/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.common;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ZoneInfo {
    public static final String SDKDefaultIOHost = "sdkDefaultIOHost";
    public static final String EmptyRegionId = "sdkEmptyRegionId";
    private static int DOMAIN_FROZEN_SECONDS = 600;
    public final int ttl;
    public final List<String> domains;
    public final List<String> old_domains;
    public final String regionId;
    public List<String> allHosts;
    public JSONObject detailInfo;
    private final Date buildDate;

    public static ZoneInfo buildInfo(List<String> mainHosts, String regionId) {
        return ZoneInfo.buildInfo(mainHosts, null, regionId);
    }

    public static ZoneInfo buildInfo(List<String> mainHosts, List<String> oldHosts, String regionId) {
        if (mainHosts == null) {
            return null;
        }
        HashMap<String, List<String>> up = new HashMap<String, List<String>>();
        up.put("domains", mainHosts);
        if (oldHosts != null) {
            up.put("old", oldHosts);
        }
        if (regionId == null) {
            regionId = EmptyRegionId;
        }
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("ttl", 86400000);
        info.put("region", regionId);
        info.put("up", up);
        JSONObject object = new JSONObject(info);
        ZoneInfo zoneInfo = null;
        try {
            zoneInfo = ZoneInfo.buildFromJson(object);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return zoneInfo;
    }

    private ZoneInfo(int ttl, String regionId, List<String> domains, List<String> old_domains) {
        this.ttl = ttl;
        this.regionId = regionId;
        this.domains = domains;
        this.old_domains = old_domains;
        this.buildDate = new Date();
    }

    public static ZoneInfo buildFromJson(JSONObject obj) throws JSONException {
        JSONObject up;
        if (obj == null) {
            return null;
        }
        int ttl = obj.optInt("ttl");
        String regionId = obj.optString("region");
        if (regionId == null) {
            regionId = EmptyRegionId;
        }
        if ((up = obj.optJSONObject("up")) == null) {
            return null;
        }
        ArrayList<String> allHosts = new ArrayList<String>();
        ArrayList<String> domains = new ArrayList<String>();
        JSONArray domainsJson = up.optJSONArray("domains");
        if (domainsJson != null && domainsJson.length() > 0) {
            for (int i = 0; i < domainsJson.length(); ++i) {
                String domain = domainsJson.optString(i);
                if (domain == null || domain.length() <= 0) continue;
                domains.add(domain);
                allHosts.add(domain);
            }
        }
        ArrayList<String> old_domains = new ArrayList<String>();
        JSONArray old_domainsJson = up.optJSONArray("old");
        if (old_domainsJson != null && old_domainsJson.length() > 0) {
            for (int i = 0; i < old_domainsJson.length(); ++i) {
                String domain = old_domainsJson.optString(i);
                if (domain == null || domain.length() <= 0) continue;
                old_domains.add(domain);
                allHosts.add(domain);
            }
        }
        if (domains.size() == 0 && old_domains.size() == 0) {
            return null;
        }
        ZoneInfo zoneInfo = new ZoneInfo(ttl, regionId, domains, old_domains);
        zoneInfo.detailInfo = obj;
        zoneInfo.allHosts = allHosts;
        return zoneInfo;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public String toString() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("ttl", this.ttl);
        m.put("allHost", this.allHosts);
        return new JSONObject(m).toString();
    }

    public boolean isValid() {
        int buildTimestamp;
        int currentTimestamp = (int)((double)new Date().getTime() * 0.001);
        return this.ttl > currentTimestamp - (buildTimestamp = (int)((double)this.buildDate.getTime() * 0.001));
    }

    public static class UploadServerGroup {
        public final String info;
        public final ArrayList<String> main;
        public final ArrayList<String> backup;
        public final ArrayList<String> allHosts;

        public static UploadServerGroup buildInfoFromJson(JSONObject jsonObject) {
            String item;
            int i;
            JSONArray mainArray2;
            if (jsonObject == null) {
                return null;
            }
            String info = null;
            ArrayList<String> main = new ArrayList<String>();
            ArrayList<String> backup = new ArrayList<String>();
            ArrayList<String> allHosts = new ArrayList<String>();
            try {
                info = jsonObject.getString("info");
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            try {
                mainArray2 = jsonObject.getJSONArray("main");
                for (i = 0; i < mainArray2.length(); ++i) {
                    item = mainArray2.getString(i);
                    main.add(item);
                    allHosts.add(item);
                }
            }
            catch (JSONException mainArray2) {
                // empty catch block
            }
            try {
                mainArray2 = jsonObject.getJSONArray("backup");
                for (i = 0; i < mainArray2.length(); ++i) {
                    item = mainArray2.getString(i);
                    main.add(item);
                    allHosts.add(item);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return new UploadServerGroup(info, main, backup, allHosts);
        }

        public UploadServerGroup(String info, ArrayList<String> main, ArrayList<String> backup, ArrayList<String> allHosts) {
            this.info = info;
            this.main = main;
            this.backup = backup;
            this.allHosts = allHosts;
        }
    }
}

