/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.storage.BaseUpload;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import org.json.JSONObject;

class FormUpload
extends BaseUpload {
    private boolean isAsync = true;
    private double previousPercent;
    private RequestTransaction uploadTransaction;

    protected FormUpload(byte[] data, String key, String fileName, UpToken token, UploadOptions option, Configuration config, BaseUpload.UpTaskCompletionHandler completionHandler) {
        super(data, key, fileName, token, option, config, completionHandler);
    }

    @Override
    protected void startToUpload() {
        LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " form\u4e0a\u4f20");
        this.uploadTransaction = new RequestTransaction(this.config, this.option, this.getTargetRegion(), this.getCurrentRegion(), this.key, this.token);
        RequestProgressHandler progressHandler = new RequestProgressHandler(){

            @Override
            public void progress(long totalBytesWritten, long totalBytesExpectedToWrite) {
                if (FormUpload.this.option.progressHandler != null) {
                    double percent = (double)totalBytesWritten / (double)totalBytesExpectedToWrite;
                    if (percent > 0.95) {
                        percent = 0.95;
                    }
                    if (percent > FormUpload.this.previousPercent) {
                        FormUpload.this.previousPercent = percent;
                    } else {
                        percent = FormUpload.this.previousPercent;
                    }
                    FormUpload.this.option.progressHandler.progress(FormUpload.this.key, percent);
                }
            }
        };
        this.uploadTransaction.uploadFormData(this.data, this.fileName, this.isAsync, progressHandler, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                FormUpload.this.addRegionRequestMetricsOfOneFlow(requestMetrics);
                if (!responseInfo.isOK()) {
                    if (!FormUpload.this.switchRegionAndUploadIfNeededWithErrorResponse(responseInfo)) {
                        FormUpload.this.completeAction(responseInfo, response);
                    }
                    return;
                }
                AsyncRun.runInMain(new Runnable(){

                    @Override
                    public void run() {
                        FormUpload.this.option.progressHandler.progress(FormUpload.this.key, 1.0);
                    }
                });
                FormUpload.this.completeAction(responseInfo, response);
            }
        });
    }
}

