/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.collect;

import com.qiniu.android.http.ResponseInfo;
import java.util.HashMap;
import org.json.JSONObject;

public class ReportItem {
    private HashMap<String, Object> keyValues = new HashMap();
    public static final String LogTypeRequest = "request";
    public static final String LogTypeBlock = "block";
    public static final String LogTypeQuality = "quality";
    public static final String RequestKeyLogType = "log_type";
    public static final String RequestKeyUpTime = "up_time";
    public static final String RequestKeyStatusCode = "status_code";
    public static final String RequestKeyRequestId = "req_id";
    public static final String RequestKeyHost = "host";
    public static final String RequestKeyRemoteIp = "remote_ip";
    public static final String RequestKeyPort = "port";
    public static final String RequestKeyTargetBucket = "target_bucket";
    public static final String RequestKeyTargetKey = "target_key";
    public static final String RequestKeyTotalElapsedTime = "total_elapsed_time";
    public static final String RequestKeyDnsElapsedTime = "dns_elapsed_time";
    public static final String RequestKeyConnectElapsedTime = "connect_elapsed_time";
    public static final String RequestKeyTLSConnectElapsedTime = "tls_connect_elapsed_time";
    public static final String RequestKeyRequestElapsedTime = "request_elapsed_time";
    public static final String RequestKeyWaitElapsedTime = "wait_elapsed_time";
    public static final String RequestKeyResponseElapsedTime = "response_elapsed_time";
    public static final String RequestKeyFileOffset = "file_offset";
    public static final String RequestKeyBytesSent = "bytes_sent";
    public static final String RequestKeyBytesTotal = "bytes_total";
    public static final String RequestKeyPid = "pid";
    public static final String RequestKeyTid = "tid";
    public static final String RequestKeyTargetRegionId = "target_region_id";
    public static final String RequestKeyCurrentRegionId = "current_region_id";
    public static final String RequestKeyErrorType = "error_type";
    public static final String RequestKeyErrorDescription = "error_description";
    public static final String RequestKeyUpType = "up_type";
    public static final String RequestKeyOsName = "os_name";
    public static final String RequestKeyOsVersion = "os_version";
    public static final String RequestKeySDKName = "sdk_name";
    public static final String RequestKeySDKVersion = "sdk_version";
    public static final String RequestKeyClientTime = "client_time";
    public static final String RequestKeyHttpClient = "http_client";
    public static final String RequestKeyHttpClientVersion = "http_client_version";
    public static final String RequestKeyNetworkType = "network_type";
    public static final String RequestKeySignalStrength = "signal_strength";
    public static final String RequestKeyPrefetchedDnsSource = "prefetched_dns_source";
    public static final String RequestKeyPrefetchedBefore = "prefetched_before";
    public static final String RequestKeyPrefetchedErrorMessage = "prefetched_error_message";
    public static final String BlockKeyLogType = "log_type";
    public static final String BlockKeyUpTime = "up_time";
    public static final String BlockKeyTargetBucket = "target_bucket";
    public static final String BlockKeyTargetKey = "target_key";
    public static final String BlockKeyTargetRegionId = "target_region_id";
    public static final String BlockKeyCurrentRegionId = "current_region_id";
    public static final String BlockKeyTotalElapsedTime = "total_elapsed_time";
    public static final String BlockKeyBytesSent = "bytes_sent";
    public static final String BlockKeyRecoveredFrom = "recovered_from";
    public static final String BlockKeyFileSize = "file_size";
    public static final String BlockKeyPid = "pid";
    public static final String BlockKeyTid = "tid";
    public static final String BlockKeyUpApiVersion = "up_api_version";
    public static final String BlockKeyClientTime = "client_time";
    public static final String BlockKeyOsName = "os_name";
    public static final String BlockKeyOsVersion = "os_version";
    public static final String BlockKeySDKName = "sdk_name";
    public static final String BlockKeySDKVersion = "sdk_version";
    public static final String QualityKeyLogType = "log_type";
    public static final String QualityKeyUpTime = "up_time";
    public static final String QualityKeyResult = "result";
    public static final String QualityKeyTargetBucket = "target_bucket";
    public static final String QualityKeyTargetKey = "target_key";
    public static final String QualityKeyTotalElapsedTime = "total_elapsed_time";
    public static final String QualityKeyRequestsCount = "requests_count";
    public static final String QualityKeyRegionsCount = "regions_count";
    public static final String QualityKeyBytesSent = "bytes_sent";
    public static final String QualityKeyCloudType = "cloud_type";
    public static final String QualityKeyErrorType = "error_type";
    public static final String QualityKeyErrorDescription = "error_description";
    public static final String QualityKeyOsName = "os_name";
    public static final String QualityKeyOsVersion = "os_version";
    public static final String QualityKeySDKName = "sdk_name";
    public static final String QualityKeySDKVersion = "sdk_version";

    public void setReport(Object value, String key) {
        if (key == null || value == null) {
            return;
        }
        this.keyValues.put(key, value);
    }

    public void removeReportValue(String key) {
        if (key == null) {
            return;
        }
        this.keyValues.remove(key);
    }

    public String toJson() {
        String jsonString = "{}";
        if (this.keyValues == null || this.keyValues.size() == 0) {
            return jsonString;
        }
        jsonString = new JSONObject(this.keyValues).toString();
        return jsonString;
    }

    public static String requestReportStatusCode(ResponseInfo responseInfo) {
        if (responseInfo == null) {
            return null;
        }
        return responseInfo.statusCode + "";
    }

    public static String requestReportErrorType(ResponseInfo responseInfo) {
        if (responseInfo == null) {
            return "unknown_error";
        }
        String errorType = null;
        if (responseInfo.statusCode <= 199 || responseInfo.statusCode >= 300) {
            errorType = responseInfo.statusCode > 299 ? "response_error" : (responseInfo.statusCode == -1 ? "network_error" : (responseInfo.statusCode == -1001 ? "timeout" : (responseInfo.statusCode == -1003 ? "unknown_host" : (responseInfo.statusCode == -1004 ? "cannot_connect_to_host" : (responseInfo.statusCode == -1005 ? "transmission_error" : (responseInfo.statusCode == -1200 ? "ssl_error" : (responseInfo.statusCode == -1015 ? "parse_error" : (responseInfo.statusCode == -8 ? "malicious_response" : (responseInfo.statusCode == -2 ? "user_canceled" : (responseInfo.statusCode == -7 ? "local_io_error" : (responseInfo.statusCode == 100 ? "protocol_error" : (responseInfo.statusCode == -1009 ? "network_slow" : "unknown_error"))))))))))));
        }
        return errorType;
    }

    public static String qualityResult(ResponseInfo responseInfo) {
        if (responseInfo == null) {
            return "unknown_error";
        }
        String result = null;
        if (responseInfo.statusCode > 199 && responseInfo.statusCode < 300) {
            result = "ok";
        } else if (responseInfo.statusCode > 399 && (responseInfo.statusCode < 500 || responseInfo.statusCode == 573 || responseInfo.statusCode == 579 || responseInfo.statusCode == 608 || responseInfo.statusCode == 612 || responseInfo.statusCode == 614 || responseInfo.statusCode == 630 || responseInfo.statusCode == 631 || responseInfo.statusCode == 701)) {
            result = "bad_request";
        } else if (responseInfo.statusCode == -6) {
            result = "zero_size_file";
        } else if (responseInfo.statusCode == -3) {
            result = "invalid_file";
        } else if (responseInfo.statusCode == -5 || responseInfo.statusCode == -4) {
            result = "invalid_args";
        }
        if (result == null) {
            result = ReportItem.requestReportErrorType(responseInfo);
        }
        return result;
    }
}

