/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.IUploadRegion;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.http.serverRegion.UploadDomainRegion;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadFileInfo;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

abstract class PartsUploadPerformer {
    private static final String kRecordFileInfoKey = "recordFileInfo";
    private static final String kRecordZoneInfoKey = "recordZoneInfo";
    final String key;
    final String fileName;
    final File file;
    final RandomAccessFile randomAccessFile;
    final UpToken token;
    final UploadOptions options;
    final Configuration config;
    final Recorder recorder;
    final String recorderKey;
    private IUploadRegion targetRegion;
    protected IUploadRegion currentRegion;
    private double previousPercent;
    Long recoveredFrom;
    UploadFileInfo fileInfo;
    List<RequestTransaction> uploadTransactions;

    PartsUploadPerformer(File file, String fileName, String key, UpToken token, UploadOptions options, Configuration config, String recorderKey) {
        this.file = file;
        this.key = key;
        this.fileName = fileName;
        this.token = token;
        this.options = options;
        this.config = config;
        this.recorder = config.recorder;
        this.recorderKey = recorderKey;
        RandomAccessFile randomAccessFile = null;
        if (file != null) {
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        this.randomAccessFile = randomAccessFile;
        this.initData();
    }

    void initData() {
        this.uploadTransactions = new ArrayList<RequestTransaction>();
        this.recoverUploadInfoFromRecord();
        if (this.fileInfo == null) {
            this.fileInfo = this.getDefaultUploadFileInfo();
        }
    }

    boolean canReadFile() {
        return this.randomAccessFile != null;
    }

    void closeFile() {
        if (this.randomAccessFile != null) {
            try {
                this.randomAccessFile.close();
            }
            catch (IOException e) {
                try {
                    this.randomAccessFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    void switchRegion(IUploadRegion region) {
        if (this.fileInfo != null) {
            this.fileInfo.clearUploadState();
        }
        this.currentRegion = region;
        this.recoveredFrom = null;
        if (this.targetRegion == null) {
            this.targetRegion = region;
        }
    }

    void notifyProgress() {
        if (this.fileInfo == null) {
            return;
        }
        double percent = this.fileInfo.progress();
        if (percent > 0.95) {
            percent = 0.95;
        }
        if (percent > this.previousPercent) {
            this.previousPercent = percent;
        } else {
            percent = this.previousPercent;
        }
        final double notifyPercent = percent;
        AsyncRun.runInMain(new Runnable(){

            @Override
            public void run() {
                if (PartsUploadPerformer.this.options != null && PartsUploadPerformer.this.options.progressHandler != null) {
                    PartsUploadPerformer.this.options.progressHandler.progress(PartsUploadPerformer.this.key, notifyPercent);
                }
            }
        });
    }

    void recordUploadInfo() {
        String key = this.recorderKey;
        if (this.recorder == null || key == null || key.length() == 0) {
            return;
        }
        JSONObject zoneInfoJson = null;
        JSONObject fileInfoJson = null;
        if (this.currentRegion != null && this.currentRegion.getZoneInfo() != null) {
            zoneInfoJson = this.currentRegion.getZoneInfo().detailInfo;
        }
        if (this.fileInfo != null) {
            fileInfoJson = this.fileInfo.toJsonObject();
        }
        if (zoneInfoJson != null && this.fileInfo != null) {
            JSONObject info = new JSONObject();
            try {
                info.put(kRecordZoneInfoKey, (Object)zoneInfoJson);
                info.put(kRecordFileInfoKey, (Object)fileInfoJson);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.recorder.set(key, info.toString().getBytes());
        }
        LogUtil.i("key:" + StringUtils.toNonnullString(key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recordUploadInfo");
    }

    void removeUploadInfoRecord() {
        this.recoveredFrom = null;
        if (this.fileInfo != null) {
            this.fileInfo.clearUploadState();
        }
        if (this.recorder != null && this.recorderKey != null) {
            this.recorder.del(this.recorderKey);
        }
        LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " removeUploadInfoRecord");
    }

    void recoverUploadInfoFromRecord() {
        LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recorder:" + StringUtils.toNonnullString(this.recorder) + " recoverUploadInfoFromRecord");
        String key = this.recorderKey;
        if (this.recorder == null || key == null || key.length() == 0 || this.file == null) {
            return;
        }
        byte[] data = this.recorder.get(key);
        if (data == null) {
            LogUtil.i("key:" + StringUtils.toNonnullString(key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recoverUploadInfoFromRecord data:null");
            return;
        }
        try {
            JSONObject info = new JSONObject(new String(data));
            ZoneInfo zoneInfo = ZoneInfo.buildFromJson(info.getJSONObject(kRecordZoneInfoKey));
            UploadFileInfo recoverFileInfo = this.getFileFromJson(info.getJSONObject(kRecordFileInfoKey));
            if (zoneInfo != null && recoverFileInfo != null && !recoverFileInfo.isEmpty() && this.file != null && recoverFileInfo.size == this.file.length() && recoverFileInfo.modifyTime == this.file.lastModified()) {
                LogUtil.i("key:" + StringUtils.toNonnullString(key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recoverUploadInfoFromRecord valid");
                this.fileInfo = recoverFileInfo;
                UploadDomainRegion region = new UploadDomainRegion();
                region.setupRegionData(zoneInfo);
                this.currentRegion = region;
                this.targetRegion = region;
                this.recoveredFrom = (long)(recoverFileInfo.progress() * (double)recoverFileInfo.size);
            } else {
                LogUtil.i("key:" + StringUtils.toNonnullString(key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recoverUploadInfoFromRecord invalid");
                this.recorder.del(key);
                this.currentRegion = null;
                this.targetRegion = null;
                this.recoveredFrom = null;
            }
        }
        catch (Exception e) {
            LogUtil.i("key:" + StringUtils.toNonnullString(key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recoverUploadInfoFromRecord json:error");
            this.recorder.del(key);
            this.currentRegion = null;
            this.targetRegion = null;
            this.recoveredFrom = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RequestTransaction createUploadRequestTransaction() {
        RequestTransaction transaction = new RequestTransaction(this.config, this.options, this.targetRegion, this.currentRegion, this.key, this.token);
        PartsUploadPerformer partsUploadPerformer = this;
        synchronized (partsUploadPerformer) {
            if (this.uploadTransactions != null) {
                this.uploadTransactions.add(transaction);
            }
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyUploadRequestTransaction(RequestTransaction transaction) {
        if (transaction != null) {
            PartsUploadPerformer partsUploadPerformer = this;
            synchronized (partsUploadPerformer) {
                if (this.uploadTransactions != null) {
                    this.uploadTransactions.remove(transaction);
                }
            }
        }
    }

    abstract UploadFileInfo getDefaultUploadFileInfo();

    abstract UploadFileInfo getFileFromJson(JSONObject var1);

    abstract void serverInit(PartsUploadPerformerCompleteHandler var1);

    abstract void uploadNextData(PartsUploadPerformerDataCompleteHandler var1);

    abstract void completeUpload(PartsUploadPerformerCompleteHandler var1);

    static interface PartsUploadPerformerDataCompleteHandler {
        public void complete(boolean var1, ResponseInfo var2, UploadRegionRequestMetrics var3, JSONObject var4);
    }

    static interface PartsUploadPerformerCompleteHandler {
        public void complete(ResponseInfo var1, UploadRegionRequestMetrics var2, JSONObject var3);
    }
}

