/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http;

import android.os.Build;
import android.text.TextUtils;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.Utils;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.Random;

public final class UserAgent {
    private static UserAgent _instance = new UserAgent();
    public final String id = UserAgent.genId();
    public final String ua = UserAgent.getUserAgent(this.id);

    private UserAgent() {
    }

    public static UserAgent instance() {
        return _instance;
    }

    private static String genId() {
        Random r = new Random();
        return System.currentTimeMillis() + "" + r.nextInt(999);
    }

    static String getUserAgent(String id) {
        String addition = Utils.isDebug() ? "_Debug" : "";
        return String.format("QiniuAndroid%s/%s (%s; %s; %s", addition, "8.2.0", UserAgent.osVersion(), UserAgent.device(), id);
    }

    public static String osVersion() {
        try {
            String v = Build.VERSION.RELEASE;
            if (v == null) {
                return "-";
            }
            return StringUtils.strip(v.trim());
        }
        catch (Throwable t) {
            return "-";
        }
    }

    public static String device() {
        try {
            String model = Build.MODEL.trim();
            String device = UserAgent.deviceName(Build.MANUFACTURER.trim(), model);
            if (TextUtils.isEmpty((CharSequence)device)) {
                device = UserAgent.deviceName(Build.BRAND.trim(), model);
            }
            return StringUtils.strip((device == null ? "-" : device) + "-" + model);
        }
        catch (Throwable t) {
            return "-";
        }
    }

    private static String deviceName(String manufacturer, String model) {
        String str = manufacturer.toLowerCase(Locale.getDefault());
        if (str.startsWith("unknown") || str.startsWith("alps") || str.startsWith("android") || str.startsWith("sprd") || str.startsWith("spreadtrum") || str.startsWith("rockchip") || str.startsWith("wondermedia") || str.startsWith("mtk") || str.startsWith("mt65") || str.startsWith("nvidia") || str.startsWith("brcm") || str.startsWith("marvell") || model.toLowerCase(Locale.getDefault()).contains(str)) {
            return null;
        }
        return manufacturer;
    }

    public String getUa(String part) {
        String _part = ("" + part).trim();
        if (_part.length() > 15) {
            _part = _part.substring(0, Math.min(16, _part.length()));
        }
        return new String((this.ua + "; " + _part + ")").getBytes(Charset.forName("ISO-8859-1")));
    }
}

