/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.metrics;

import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.IUploadRegion;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UploadTaskMetrics {
    public ArrayList<IUploadRegion> regions;
    private Map<String, UploadRegionRequestMetrics> metricsInfo;

    public UploadTaskMetrics(ArrayList<IUploadRegion> regions) {
        this.regions = regions;
        this.metricsInfo = new ConcurrentHashMap<String, UploadRegionRequestMetrics>();
    }

    public long totalElapsedTime() {
        long time = 0L;
        for (String key : this.metricsInfo.keySet()) {
            UploadRegionRequestMetrics metrics = this.metricsInfo.get(key);
            if (metrics == null) continue;
            time += metrics.totalElapsedTime();
        }
        return time;
    }

    public Long requestCount() {
        long count = 0L;
        for (String key : this.metricsInfo.keySet()) {
            UploadRegionRequestMetrics metrics = this.metricsInfo.get(key);
            if (metrics == null) continue;
            count += (long)metrics.requestCount().intValue();
        }
        return count;
    }

    public Long bytesSend() {
        long bytesSend = 0L;
        for (String key : this.metricsInfo.keySet()) {
            UploadRegionRequestMetrics metrics = this.metricsInfo.get(key);
            if (metrics == null) continue;
            bytesSend += metrics.bytesSend().longValue();
        }
        return bytesSend;
    }

    public Long regionCount() {
        long count = 0L;
        for (String key : this.metricsInfo.keySet()) {
            UploadRegionRequestMetrics metrics = this.metricsInfo.get(key);
            if (metrics == null || metrics.region == null || metrics.region.getZoneInfo() == null || metrics.region.getZoneInfo().regionId.equals("sdkEmptyRegionId")) continue;
            ++count;
        }
        return count;
    }

    public void addMetrics(UploadRegionRequestMetrics metrics) {
        if (metrics == null || metrics.region == null || metrics.region.getZoneInfo() == null || metrics.region.getZoneInfo().regionId == null) {
            return;
        }
        String regionId = metrics.region.getZoneInfo().regionId;
        UploadRegionRequestMetrics metricsOld = this.metricsInfo.get(regionId);
        if (metricsOld != null) {
            metricsOld.addMetrics(metrics);
        } else {
            this.metricsInfo.put(regionId, metrics);
        }
    }
}

