/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.request;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.metrics.UploadSingleRequestMetrics;
import com.qiniu.android.http.request.HttpSingleRequest;
import com.qiniu.android.http.request.IUploadRegion;
import com.qiniu.android.http.request.IUploadServer;
import com.qiniu.android.http.request.Request;
import com.qiniu.android.http.request.UploadRequestInfo;
import com.qiniu.android.http.request.UploadRequestState;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.http.request.handler.RequestShouldRetryHandler;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import java.util.ArrayList;
import java.util.Map;
import org.json.JSONObject;

class HttpRegionRequest {
    private final Configuration config;
    private final UploadOptions uploadOption;
    private final UpToken token;
    private final IUploadRegion region;
    private final UploadRequestInfo requestInfo;
    private UploadRequestState requestState;
    private HttpSingleRequest singleRequest;
    private IUploadServer currentServer;
    private UploadRegionRequestMetrics requestMetrics;

    HttpRegionRequest(Configuration config, UploadOptions uploadOption, UpToken token, IUploadRegion region, UploadRequestInfo requestInfo, UploadRequestState requestState) {
        this.config = config;
        this.uploadOption = uploadOption;
        this.token = token;
        this.region = region;
        this.requestInfo = requestInfo;
        this.requestState = requestState;
        this.singleRequest = new HttpSingleRequest(config, uploadOption, token, requestInfo, requestState);
    }

    void get(String action, boolean isAsync, Map<String, String> header, RequestShouldRetryHandler shouldRetryHandler, RequestCompleteHandler completeHandler) {
        this.requestMetrics = new UploadRegionRequestMetrics(this.region);
        this.performRequest(this.getNextServer(null), action, isAsync, null, header, "GET", shouldRetryHandler, null, completeHandler);
    }

    void post(String action, boolean isAsync, byte[] data, Map<String, String> header, RequestShouldRetryHandler shouldRetryHandler, RequestProgressHandler progressHandler, RequestCompleteHandler completeHandler) {
        this.requestMetrics = new UploadRegionRequestMetrics(this.region);
        this.performRequest(this.getNextServer(null), action, isAsync, data, header, "POST", shouldRetryHandler, progressHandler, completeHandler);
    }

    void put(String action, boolean isAsync, byte[] data, Map<String, String> header, RequestShouldRetryHandler shouldRetryHandler, RequestProgressHandler progressHandler, RequestCompleteHandler completeHandler) {
        this.requestMetrics = new UploadRegionRequestMetrics(this.region);
        this.performRequest(this.getNextServer(null), action, isAsync, data, header, "PUT", shouldRetryHandler, progressHandler, completeHandler);
    }

    private void performRequest(IUploadServer server, final String action, final boolean isAsync, byte[] data, final Map<String, String> header, final String method, final RequestShouldRetryHandler shouldRetryHandler, final RequestProgressHandler progressHandler, final RequestCompleteHandler completeHandler) {
        if (server == null || server.getHost() == null || server.getHost().length() == 0) {
            ResponseInfo responseInfo = ResponseInfo.sdkInteriorError("server error");
            this.completeAction(responseInfo, null, completeHandler);
            return;
        }
        this.currentServer = server;
        String serverHost = server.getHost();
        String serverIP = server.getIp();
        if (this.config.urlConverter != null) {
            serverIP = null;
            serverHost = this.config.urlConverter.convert(serverHost);
        }
        String scheme = this.config.useHttps ? "https://" : "http://";
        String urlString = scheme + serverHost + (action != null ? action : "");
        final Request request = new Request(urlString, method, header, data, this.config.connectTimeout);
        request.host = serverHost;
        request.ip = serverIP;
        LogUtil.i("key:" + StringUtils.toNonnullString(this.requestInfo.key) + " url:" + StringUtils.toNonnullString(request.urlString));
        LogUtil.i("key:" + StringUtils.toNonnullString(this.requestInfo.key) + " headers:" + StringUtils.toNonnullString(request.allHeaders));
        this.singleRequest.request(request, server, isAsync, shouldRetryHandler, progressHandler, new HttpSingleRequest.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, ArrayList<UploadSingleRequestMetrics> requestMetricsList, JSONObject response) {
                HttpRegionRequest.this.requestMetrics.addMetricsList(requestMetricsList);
                if (shouldRetryHandler.shouldRetry(responseInfo, response) && ((HttpRegionRequest)HttpRegionRequest.this).config.allowBackupHost && responseInfo.couldRegionRetry()) {
                    IUploadServer newServer = HttpRegionRequest.this.getNextServer(responseInfo);
                    if (newServer != null) {
                        HttpRegionRequest.this.performRequest(newServer, action, isAsync, request.httpBody, header, method, shouldRetryHandler, progressHandler, completeHandler);
                        request.httpBody = null;
                    } else {
                        request.httpBody = null;
                        HttpRegionRequest.this.completeAction(responseInfo, response, completeHandler);
                    }
                } else {
                    request.httpBody = null;
                    HttpRegionRequest.this.completeAction(responseInfo, response, completeHandler);
                }
            }
        });
    }

    private void completeAction(ResponseInfo responseInfo, JSONObject response, RequestCompleteHandler completeHandler) {
        this.singleRequest = null;
        if (completeHandler != null) {
            completeHandler.complete(responseInfo, this.requestMetrics, response);
        }
    }

    private IUploadServer getNextServer(ResponseInfo responseInfo) {
        if (this.requestState != null && responseInfo != null && responseInfo.isTlsError()) {
            this.requestState.setUseOldServer(true);
        }
        return this.region.getNextServer(this.requestState, responseInfo, this.currentServer);
    }

    static interface RequestCompleteHandler {
        public void complete(ResponseInfo var1, UploadRegionRequestMetrics var2, JSONObject var3);
    }
}

