/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.request;

import com.qiniu.android.collect.ReportItem;
import com.qiniu.android.collect.UploadInfoReporter;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.connectCheck.ConnectChecker;
import com.qiniu.android.http.dns.DnsPrefetcher;
import com.qiniu.android.http.metrics.UploadSingleRequestMetrics;
import com.qiniu.android.http.networkStatus.NetworkStatusManager;
import com.qiniu.android.http.request.IRequestClient;
import com.qiniu.android.http.request.IUploadServer;
import com.qiniu.android.http.request.Request;
import com.qiniu.android.http.request.UploadRequestInfo;
import com.qiniu.android.http.request.UploadRequestState;
import com.qiniu.android.http.request.handler.CheckCancelHandler;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.http.request.handler.RequestShouldRetryHandler;
import com.qiniu.android.http.request.httpclient.SystemHttpClient;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.Utils;
import java.util.ArrayList;
import java.util.Locale;
import org.json.JSONObject;

class HttpSingleRequest {
    private int currentRetryTime;
    private final Configuration config;
    private final UploadOptions uploadOption;
    private final UpToken token;
    private final UploadRequestInfo requestInfo;
    private final UploadRequestState requestState;
    private ArrayList<UploadSingleRequestMetrics> requestMetricsList;
    private IRequestClient client;

    HttpSingleRequest(Configuration config, UploadOptions uploadOption, UpToken token, UploadRequestInfo requestInfo, UploadRequestState requestState) {
        this.config = config;
        this.uploadOption = uploadOption;
        this.token = token;
        this.requestInfo = requestInfo;
        this.requestState = requestState;
        this.currentRetryTime = 0;
    }

    void request(Request request, IUploadServer server, boolean isAsync, RequestShouldRetryHandler shouldRetryHandler, RequestProgressHandler progressHandler, RequestCompleteHandler completeHandler) {
        this.currentRetryTime = 0;
        this.requestMetricsList = new ArrayList();
        this.retryRequest(request, server, isAsync, shouldRetryHandler, progressHandler, completeHandler);
    }

    private void retryRequest(final Request request, final IUploadServer server, final boolean isAsync, final RequestShouldRetryHandler shouldRetryHandler, final RequestProgressHandler progressHandler, final RequestCompleteHandler completeHandler) {
        this.client = server.isHttp3() ? new SystemHttpClient() : new SystemHttpClient();
        final CheckCancelHandler checkCancelHandler = new CheckCancelHandler(){

            @Override
            public boolean checkCancel() {
                boolean isCancelled = HttpSingleRequest.this.requestState.isUserCancel();
                if (!isCancelled && ((HttpSingleRequest)HttpSingleRequest.this).uploadOption.cancellationSignal != null) {
                    isCancelled = ((HttpSingleRequest)HttpSingleRequest.this).uploadOption.cancellationSignal.isCancelled();
                }
                return isCancelled;
            }
        };
        LogUtil.i("key:" + StringUtils.toNonnullString(this.requestInfo.key) + " retry:" + this.currentRetryTime + " url:" + StringUtils.toNonnullString(request.urlString) + " ip:" + StringUtils.toNonnullString(request.ip));
        this.client.request(request, isAsync, this.config.proxy, new IRequestClient.RequestClientProgress(){

            @Override
            public void progress(long totalBytesWritten, long totalBytesExpectedToWrite) {
                if (checkCancelHandler.checkCancel()) {
                    HttpSingleRequest.this.requestState.setUserCancel(true);
                    if (HttpSingleRequest.this.client != null) {
                        HttpSingleRequest.this.client.cancel();
                    }
                } else if (progressHandler != null) {
                    progressHandler.progress(totalBytesWritten, totalBytesExpectedToWrite);
                }
            }
        }, new IRequestClient.RequestClientCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadSingleRequestMetrics metrics, JSONObject response) {
                if (metrics != null) {
                    HttpSingleRequest.this.requestMetricsList.add(metrics);
                }
                if (HttpSingleRequest.this.shouldCheckConnect(responseInfo)) {
                    UploadSingleRequestMetrics checkMetrics = ConnectChecker.check();
                    if (metrics != null) {
                        metrics.connectCheckMetrics = checkMetrics;
                    }
                    if (!ConnectChecker.isConnected(checkMetrics)) {
                        String message = "check origin statusCode:" + responseInfo.statusCode + " error:" + responseInfo.error;
                        responseInfo = ResponseInfo.errorInfo(-1009, message);
                    }
                }
                LogUtil.i("key:" + StringUtils.toNonnullString(((HttpSingleRequest)HttpSingleRequest.this).requestInfo.key) + " response:" + StringUtils.toNonnullString(responseInfo));
                if (shouldRetryHandler != null && shouldRetryHandler.shouldRetry(responseInfo, response) && HttpSingleRequest.this.currentRetryTime < ((HttpSingleRequest)HttpSingleRequest.this).config.retryMax && responseInfo.couldHostRetry()) {
                    HttpSingleRequest.this.currentRetryTime += 1;
                    try {
                        Thread.sleep(((HttpSingleRequest)HttpSingleRequest.this).config.retryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    HttpSingleRequest.this.retryRequest(request, server, isAsync, shouldRetryHandler, progressHandler, completeHandler);
                } else {
                    HttpSingleRequest.this.completeAction(server, responseInfo, response, metrics, completeHandler);
                }
            }
        });
    }

    private boolean shouldCheckConnect(ResponseInfo responseInfo) {
        return responseInfo != null && (responseInfo.statusCode == -1 || responseInfo.statusCode == -1001 || responseInfo.statusCode == -1003 || responseInfo.statusCode == -1004 || responseInfo.statusCode == -1005 || responseInfo.statusCode == -1009 || responseInfo.isTlsError());
    }

    private synchronized void completeAction(IUploadServer server, ResponseInfo responseInfo, JSONObject response, UploadSingleRequestMetrics requestMetrics, RequestCompleteHandler completeHandler) {
        if (this.client == null) {
            return;
        }
        this.client = null;
        this.updateHostNetworkStatus(responseInfo, server, requestMetrics);
        this.reportRequest(responseInfo, server, requestMetrics);
        if (completeHandler != null) {
            completeHandler.complete(responseInfo, this.requestMetricsList, response);
        }
    }

    private void updateHostNetworkStatus(ResponseInfo responseInfo, IUploadServer server, UploadSingleRequestMetrics requestMetrics) {
        if (requestMetrics == null) {
            return;
        }
        long byteCount = requestMetrics.bytesSend();
        long second = requestMetrics.totalElapsedTime();
        if (second > 0L && byteCount >= 0x100000L) {
            int speed = (int)(byteCount * 1000L / second);
            String type = NetworkStatusManager.getNetworkStatusType(server.getHost(), server.getIp());
            NetworkStatusManager.getInstance().updateNetworkStatus(type, speed);
        }
    }

    private void reportRequest(ResponseInfo responseInfo, IUploadServer server, UploadSingleRequestMetrics requestMetrics) {
        if (this.token == null || !this.token.isValid() || this.requestInfo == null || !this.requestInfo.shouldReportRequestLog() || requestMetrics == null) {
            return;
        }
        long currentTimestamp = Utils.currentTimestamp();
        ReportItem item = new ReportItem();
        item.setReport("request", "log_type");
        item.setReport(currentTimestamp / 1000L, "up_time");
        item.setReport(ReportItem.requestReportStatusCode(responseInfo), "status_code");
        item.setReport(responseInfo != null ? responseInfo.reqId : null, "req_id");
        item.setReport(requestMetrics.request != null ? requestMetrics.request.host : null, "host");
        item.setReport(requestMetrics.remoteAddress, "remote_ip");
        item.setReport(requestMetrics.remotePort, "port");
        item.setReport(this.requestInfo.bucket, "target_bucket");
        item.setReport(this.requestInfo.key, "target_key");
        item.setReport(requestMetrics.totalElapsedTime(), "total_elapsed_time");
        item.setReport(requestMetrics.totalDnsTime(), "dns_elapsed_time");
        item.setReport(requestMetrics.totalConnectTime(), "connect_elapsed_time");
        item.setReport(requestMetrics.totalSecureConnectTime(), "tls_connect_elapsed_time");
        item.setReport(requestMetrics.totalRequestTime(), "request_elapsed_time");
        item.setReport(requestMetrics.totalWaitTime(), "wait_elapsed_time");
        item.setReport(requestMetrics.totalWaitTime(), "response_elapsed_time");
        item.setReport(requestMetrics.totalResponseTime(), "response_elapsed_time");
        item.setReport(this.requestInfo.fileOffset, "file_offset");
        item.setReport(requestMetrics.bytesSend(), "bytes_sent");
        item.setReport(requestMetrics.totalBytes(), "bytes_total");
        item.setReport(Utils.getCurrentProcessID(), "pid");
        item.setReport(Utils.getCurrentThreadID(), "tid");
        item.setReport(this.requestInfo.targetRegionId, "target_region_id");
        item.setReport(this.requestInfo.currentRegionId, "current_region_id");
        String errorType = ReportItem.requestReportErrorType(responseInfo);
        item.setReport(errorType, "error_type");
        String errorDesc = null;
        if (responseInfo != null && errorType != null) {
            errorDesc = responseInfo.error != null ? responseInfo.error : responseInfo.message;
        }
        item.setReport(errorDesc, "error_description");
        item.setReport(this.requestInfo.requestType, "up_type");
        item.setReport(Utils.systemName(), "os_name");
        item.setReport(Utils.systemVersion(), "os_version");
        item.setReport(Utils.sdkLanguage(), "sdk_name");
        item.setReport(Utils.sdkVerion(), "sdk_version");
        item.setReport(currentTimestamp, "client_time");
        item.setReport(Utils.getCurrentNetworkType(), "network_type");
        item.setReport(Utils.getCurrentSignalStrength(), "signal_strength");
        item.setReport(server.getSource(), "prefetched_dns_source");
        if (server.getIpPrefetchedTime() != null) {
            Long prefetchTime = server.getIpPrefetchedTime() - currentTimestamp;
            item.setReport(prefetchTime, "prefetched_before");
        }
        item.setReport(DnsPrefetcher.getInstance().lastPrefetchErrorMessage, "prefetched_error_message");
        item.setReport(requestMetrics.clientName, "http_client");
        item.setReport(requestMetrics.clientVersion, "http_client_version");
        if (requestMetrics.connectCheckMetrics != null) {
            String connectCheckDuration = String.format(Locale.ENGLISH, "%d", requestMetrics.connectCheckMetrics.totalElapsedTime());
            String connectCheckStatusCode = "";
            if (requestMetrics.connectCheckMetrics.response != null) {
                connectCheckStatusCode = String.format(Locale.ENGLISH, "%d", requestMetrics.connectCheckMetrics.response.statusCode);
            }
            String networkMeasuring = String.format("duration:%s status_code:%s", connectCheckDuration, connectCheckStatusCode);
            item.setReport(networkMeasuring, "network_measuring");
        }
        item.setReport(requestMetrics.httpVersion, "http_version");
        UploadInfoReporter.getInstance().report(item, this.token.token);
    }

    static interface RequestCompleteHandler {
        public void complete(ResponseInfo var1, ArrayList<UploadSingleRequestMetrics> var2, JSONObject var3);
    }
}

