/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.request;

import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.UserAgent;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.HttpRegionRequest;
import com.qiniu.android.http.request.IUploadRegion;
import com.qiniu.android.http.request.UploadRequestInfo;
import com.qiniu.android.http.request.UploadRequestState;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.http.request.handler.RequestShouldRetryHandler;
import com.qiniu.android.http.serverRegion.UploadDomainRegion;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.Crc32;
import com.qiniu.android.utils.GZipUtil;
import com.qiniu.android.utils.MD5;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.UrlSafeBase64;
import com.qiniu.android.utils.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class RequestTransaction {
    private final Configuration config;
    private final UploadOptions uploadOption;
    private final String key;
    private final UpToken token;
    private final String userAgent;
    private UploadRequestInfo requestInfo;
    private UploadRequestState requestState;
    private HttpRegionRequest regionRequest;

    public RequestTransaction(List<String> hosts, UpToken token) {
        this(new Configuration.Builder().build(), UploadOptions.defaultOptions(), hosts, null, null, token);
    }

    public RequestTransaction(List<String> hosts, String regionId, UpToken token) {
        this(new Configuration.Builder().build(), UploadOptions.defaultOptions(), hosts, regionId, null, token);
    }

    public RequestTransaction(Configuration config, UploadOptions uploadOption, List<String> hosts, String regionId, String key, UpToken token) {
        this(config, uploadOption, key, token);
        UploadDomainRegion region = new UploadDomainRegion();
        region.setupRegionData(ZoneInfo.buildInfo(hosts, regionId));
        this.initData(region, region);
    }

    public RequestTransaction(Configuration config, UploadOptions uploadOption, IUploadRegion targetRegion, IUploadRegion currentRegion, String key, UpToken token) {
        this(config, uploadOption, key, token);
        this.initData(targetRegion, currentRegion);
    }

    private RequestTransaction(Configuration config, UploadOptions uploadOption, String key, UpToken token) {
        this.config = config;
        this.uploadOption = uploadOption;
        this.key = key;
        this.token = token;
        this.userAgent = UserAgent.instance().getUa(token.accessKey != null ? token.accessKey : "");
    }

    private void initData(IUploadRegion targetRegion, IUploadRegion currentRegion) {
        this.requestState = new UploadRequestState();
        this.requestInfo = new UploadRequestInfo();
        this.requestInfo.targetRegionId = targetRegion.getZoneInfo().getRegionId();
        this.requestInfo.currentRegionId = currentRegion.getZoneInfo().getRegionId();
        this.requestInfo.bucket = this.token.bucket;
        this.requestInfo.key = this.key;
        this.regionRequest = new HttpRegionRequest(this.config, this.uploadOption, this.token, currentRegion, this.requestInfo, this.requestState);
    }

    public void queryUploadHosts(boolean isAsync, final RequestCompleteHandler completeHandler) {
        this.requestInfo.requestType = "uc_query";
        RequestShouldRetryHandler shouldRetryHandler = new RequestShouldRetryHandler(){

            @Override
            public boolean shouldRetry(ResponseInfo responseInfo, JSONObject response) {
                return !responseInfo.isOK();
            }
        };
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("User-Agent", this.userAgent);
        String action = String.format("/v4/query?ak=%s&bucket=%s&sdk_version=%s&sdk_name=%s", this.token.accessKey, this.token.bucket, Utils.sdkVerion(), Utils.sdkLanguage());
        this.regionRequest.get(action, isAsync, header, shouldRetryHandler, new HttpRegionRequest.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                RequestTransaction.this.completeAction(responseInfo, requestMetrics, response, completeHandler);
            }
        });
    }

    public void uploadFormData(byte[] data, String fileName, boolean isAsync, RequestProgressHandler progressHandler, final RequestCompleteHandler completeHandler) {
        this.requestInfo.requestType = "form";
        HashMap<String, String> param = new HashMap<String, String>();
        if (this.uploadOption.params != null) {
            param.putAll(this.uploadOption.params);
        }
        if (this.uploadOption.metaDataParam != null) {
            param.putAll(this.uploadOption.metaDataParam);
        }
        if (this.key != null && this.key.length() > 0) {
            param.put("key", this.key);
        }
        param.put("token", this.token.token != null ? this.token.token : "");
        if (this.uploadOption.checkCrc) {
            param.put("crc32", String.valueOf(Crc32.bytes(data)));
        }
        String boundary = "werghnvt54wef654rjuhgb56trtg34tweuyrgf";
        String disposition = "Content-Disposition: form-data";
        StringBuilder paramPairString = new StringBuilder();
        Set paramKeySet = param.keySet();
        for (String key : paramKeySet) {
            String value = (String)param.get(key);
            paramPairString.append(String.format("--%s\r\n%s; name=\"%s\"\r\n\r\n", boundary, disposition, key));
            paramPairString.append(String.format("%s\r\n", value));
        }
        fileName = Utils.formEscape(fileName);
        String filePairFrontString = String.format("--%s\r\n%s; name=\"%s\"; filename=\"%s\"\nContent-Type:%s\r\n\r\n", boundary, disposition, "file", fileName, this.uploadOption.mimeType);
        String filePairBehindString = String.format("\r\n--%s--\r\n", boundary);
        byte[] paramPair = paramPairString.toString().getBytes();
        byte[] filePairFront = filePairFrontString.getBytes();
        byte[] filePairBehind = filePairBehindString.getBytes();
        byte[] body = new byte[paramPair.length + filePairFront.length + data.length + filePairBehind.length];
        System.arraycopy(paramPair, 0, body, 0, paramPair.length);
        System.arraycopy(filePairFront, 0, body, paramPair.length, filePairFront.length);
        System.arraycopy(data, 0, body, paramPair.length + filePairFront.length, data.length);
        System.arraycopy(filePairBehind, 0, body, paramPair.length + filePairFront.length + data.length, filePairBehind.length);
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "multipart/form-data; boundary=" + boundary);
        header.put("Content-Length", String.valueOf(body.length));
        header.put("User-Agent", this.userAgent);
        RequestShouldRetryHandler shouldRetryHandler = new RequestShouldRetryHandler(){

            @Override
            public boolean shouldRetry(ResponseInfo responseInfo, JSONObject response) {
                return !responseInfo.isOK();
            }
        };
        this.regionRequest.post(null, isAsync, body, header, shouldRetryHandler, progressHandler, new HttpRegionRequest.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                RequestTransaction.this.completeAction(responseInfo, requestMetrics, response, completeHandler);
            }
        });
    }

    public void makeBlock(long blockOffset, long blockSize, byte[] firstChunkData, boolean isAsync, RequestProgressHandler progressHandler, final RequestCompleteHandler completeHandler) {
        this.requestInfo.requestType = "mkblk";
        this.requestInfo.fileOffset = blockOffset;
        String token = String.format("UpToken %s", this.token.token != null ? this.token.token : "");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", token);
        header.put("Content-Type", "application/octet-stream");
        header.put("User-Agent", this.userAgent);
        String action = "/mkblk/" + blockSize;
        final String chunkCrc = "" + Crc32.bytes(firstChunkData);
        RequestShouldRetryHandler shouldRetryHandler = new RequestShouldRetryHandler(){

            @Override
            public boolean shouldRetry(ResponseInfo responseInfo, JSONObject response) {
                if (response == null) {
                    return true;
                }
                String ctx = null;
                String crcServer = null;
                try {
                    ctx = response.getString("ctx");
                    crcServer = String.valueOf(response.getLong("crc32"));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return !responseInfo.isOK() || ctx == null || crcServer == null || !chunkCrc.equals(crcServer);
            }
        };
        this.regionRequest.post(action, isAsync, firstChunkData, header, shouldRetryHandler, progressHandler, new HttpRegionRequest.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                RequestTransaction.this.completeAction(responseInfo, requestMetrics, response, completeHandler);
            }
        });
    }

    public void uploadChunk(String blockContext, long blockOffset, byte[] chunkData, long chunkOffset, boolean isAsync, RequestProgressHandler progressHandler, final RequestCompleteHandler completeHandler) {
        this.requestInfo.requestType = "bput";
        this.requestInfo.fileOffset = blockOffset + chunkOffset;
        String token = String.format("UpToken %s", this.token.token != null ? this.token.token : "");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", token);
        header.put("Content-Type", "application/octet-stream");
        header.put("User-Agent", this.userAgent);
        String action = String.format("/bput/%s/%s", blockContext, chunkOffset + "");
        final String chunkCrc = "" + Crc32.bytes(chunkData);
        RequestShouldRetryHandler shouldRetryHandler = new RequestShouldRetryHandler(){

            @Override
            public boolean shouldRetry(ResponseInfo responseInfo, JSONObject response) {
                if (response == null) {
                    return true;
                }
                String ctx = null;
                String crcServer = null;
                try {
                    ctx = response.getString("ctx");
                    crcServer = String.valueOf(response.getLong("crc32"));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return !responseInfo.isOK() || ctx == null || crcServer == null || !chunkCrc.equals(crcServer);
            }
        };
        this.regionRequest.post(action, isAsync, chunkData, header, shouldRetryHandler, progressHandler, new HttpRegionRequest.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                RequestTransaction.this.completeAction(responseInfo, requestMetrics, response, completeHandler);
            }
        });
    }

    public void makeFile(long fileSize, String fileName, String[] blockContexts, boolean isAsync, final RequestCompleteHandler completeHandler) {
        String param;
        String value;
        Set<String> paramKeySet;
        this.requestInfo.requestType = "mkfile";
        if (blockContexts == null) {
            ResponseInfo responseInfo = ResponseInfo.invalidArgument("invalid blockContexts");
            this.completeAction(responseInfo, null, responseInfo.response, completeHandler);
            return;
        }
        String token = String.format("UpToken %s", this.token.token != null ? this.token.token : "");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", token);
        header.put("Content-Type", "application/octet-stream");
        header.put("User-Agent", this.userAgent);
        String mimeType = String.format("/mimeType/%s", UrlSafeBase64.encodeToString(this.uploadOption.mimeType));
        String action = "/mkfile/" + fileSize + mimeType;
        if (this.key != null) {
            String keyStr = String.format("/key/%s", UrlSafeBase64.encodeToString(this.key));
            action = action + keyStr;
        }
        if (this.uploadOption.params != null) {
            paramKeySet = this.uploadOption.params.keySet();
            for (String paramKey : paramKeySet) {
                value = this.uploadOption.params.get(paramKey);
                if (value == null) continue;
                param = "/" + paramKey + "/" + UrlSafeBase64.encodeToString(value);
                action = action + param;
            }
        }
        if (this.uploadOption.metaDataParam != null) {
            paramKeySet = this.uploadOption.metaDataParam.keySet();
            for (String paramKey : paramKeySet) {
                value = this.uploadOption.metaDataParam.get(paramKey);
                if (value == null) continue;
                param = "/" + paramKey + "/" + UrlSafeBase64.encodeToString(value);
                action = action + param;
            }
        }
        String fname = String.format("/fname/%s", UrlSafeBase64.encodeToString(fileName));
        action = action + fname;
        byte[] body = StringUtils.join(blockContexts, ",").getBytes();
        RequestShouldRetryHandler shouldRetryHandler = new RequestShouldRetryHandler(){

            @Override
            public boolean shouldRetry(ResponseInfo responseInfo, JSONObject response) {
                return !responseInfo.isOK();
            }
        };
        this.regionRequest.post(action, isAsync, body, header, shouldRetryHandler, null, new HttpRegionRequest.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                RequestTransaction.this.completeAction(responseInfo, requestMetrics, response, completeHandler);
            }
        });
    }

    public void initPart(boolean isAsync, final RequestCompleteHandler completeHandler) {
        this.requestInfo.requestType = "init_parts";
        String token = String.format("UpToken %s", this.token.token != null ? this.token.token : "");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", token);
        header.put("Content-Type", "application/octet-stream");
        header.put("User-Agent", this.userAgent);
        String buckets = "/buckets/" + this.token.bucket;
        String objects = "/objects/" + this.resumeV2EncodeKey(this.key);
        String action = buckets + objects + "/uploads";
        RequestShouldRetryHandler shouldRetryHandler = new RequestShouldRetryHandler(){

            @Override
            public boolean shouldRetry(ResponseInfo responseInfo, JSONObject response) {
                return !responseInfo.isOK();
            }
        };
        this.regionRequest.post(action, isAsync, null, header, shouldRetryHandler, null, new HttpRegionRequest.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }

    public void uploadPart(boolean isAsync, String uploadId, int partIndex, byte[] partData, RequestProgressHandler progressHandler, final RequestCompleteHandler completeHandler) {
        String md5;
        this.requestInfo.requestType = "upload_part";
        String token = String.format("UpToken %s", this.token.token != null ? this.token.token : "");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", token);
        header.put("Content-Type", "application/octet-stream");
        header.put("User-Agent", this.userAgent);
        if (this.uploadOption.checkCrc && (md5 = MD5.encrypt(partData)) != null) {
            header.put("Content-MD5", md5);
        }
        String buckets = "/buckets/" + this.token.bucket;
        String objects = "/objects/" + this.resumeV2EncodeKey(this.key);
        String uploads = "/uploads/" + uploadId;
        String partNumber = "/" + partIndex;
        String action = buckets + objects + uploads + partNumber;
        RequestShouldRetryHandler shouldRetryHandler = new RequestShouldRetryHandler(){

            @Override
            public boolean shouldRetry(ResponseInfo responseInfo, JSONObject response) {
                if (response == null) {
                    return true;
                }
                String etag = null;
                String serverMd5 = null;
                try {
                    etag = response.getString("etag");
                    serverMd5 = response.getString("md5");
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                return !responseInfo.isOK() || etag == null || serverMd5 == null;
            }
        };
        this.regionRequest.put(action, isAsync, partData, header, shouldRetryHandler, progressHandler, new HttpRegionRequest.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }

    public void completeParts(boolean isAsync, String fileName, String uploadId, List<Map<String, Object>> partInfoArray, final RequestCompleteHandler completeHandler) {
        this.requestInfo.requestType = "complete_part";
        if (partInfoArray == null || partInfoArray.size() == 0) {
            ResponseInfo responseInfo = ResponseInfo.invalidArgument("partInfoArray");
            if (completeHandler != null) {
                completeHandler.complete(responseInfo, null, responseInfo.response);
            }
            return;
        }
        String token = String.format("UpToken %s", this.token.token != null ? this.token.token : "");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", token);
        header.put("Content-Type", "application/octet-stream");
        header.put("User-Agent", this.userAgent);
        String buckets = "/buckets/" + this.token.bucket;
        String objects = "/objects/" + this.resumeV2EncodeKey(this.key);
        String uploads = "/uploads/" + uploadId;
        String action = buckets + objects + uploads;
        HashMap<String, Object> bodyMap = new HashMap<String, Object>();
        if (partInfoArray != null) {
            bodyMap.put("parts", partInfoArray);
        }
        if (fileName != null) {
            bodyMap.put("fname", fileName);
        }
        if (this.uploadOption.mimeType != null) {
            bodyMap.put("mimeType", this.uploadOption.mimeType);
        }
        if (this.uploadOption.params != null) {
            bodyMap.put("customVars", this.uploadOption.params);
        }
        if (this.uploadOption.metaDataParam != null) {
            bodyMap.put("metaData", this.uploadOption.metaDataParam);
        }
        String bodyString = new JSONObject(bodyMap).toString();
        byte[] body = bodyString.getBytes();
        RequestShouldRetryHandler shouldRetryHandler = new RequestShouldRetryHandler(){

            @Override
            public boolean shouldRetry(ResponseInfo responseInfo, JSONObject response) {
                return !responseInfo.isOK();
            }
        };
        this.regionRequest.post(action, isAsync, body, header, shouldRetryHandler, null, new HttpRegionRequest.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }

    public void reportLog(byte[] logData, String logClientId, boolean isAsync, final RequestCompleteHandler completeHandler) {
        this.requestInfo.requestType = "uplog";
        String token = String.format("UpToken %s", this.token.token != null ? this.token.token : "");
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", token);
        header.put("Content-Type", "text/plain");
        header.put("User-Agent", this.userAgent);
        if (logClientId != null) {
            header.put("X-Log-Client-Id", logClientId);
        }
        RequestShouldRetryHandler shouldRetryHandler = new RequestShouldRetryHandler(){

            @Override
            public boolean shouldRetry(ResponseInfo responseInfo, JSONObject response) {
                return !responseInfo.isOK();
            }
        };
        this.regionRequest.post("/log/4?compressed=gzip", isAsync, GZipUtil.gZip(logData), header, shouldRetryHandler, null, new HttpRegionRequest.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                RequestTransaction.this.completeAction(responseInfo, requestMetrics, response, completeHandler);
            }
        });
    }

    private String resumeV2EncodeKey(String key) {
        String encodeKey = null;
        encodeKey = key == null ? "~" : (key.equals("") ? "" : UrlSafeBase64.encodeToString(key));
        return encodeKey;
    }

    private void completeAction(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response, RequestCompleteHandler completeHandler) {
        this.requestInfo = null;
        this.regionRequest = null;
        this.regionRequest = null;
        if (completeHandler != null) {
            completeHandler.complete(responseInfo, requestMetrics, response);
        }
    }

    public static interface RequestCompleteHandler {
        public void complete(ResponseInfo var1, UploadRegionRequestMetrics var2, JSONObject var3);
    }
}

