/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.PartsUploadPerformer;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadData;
import com.qiniu.android.storage.UploadFileInfo;
import com.qiniu.android.storage.UploadFileInfoPartV2;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class PartsUploadPerformerV2
extends PartsUploadPerformer {
    PartsUploadPerformerV2(File file, String fileName, String key, UpToken token, UploadOptions options, Configuration config, String recorderKey) {
        super(file, fileName, key, token, options, config, recorderKey);
    }

    @Override
    UploadFileInfo getFileFromJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return UploadFileInfoPartV2.fileFromJson(jsonObject);
    }

    @Override
    UploadFileInfo getDefaultUploadFileInfo() {
        return new UploadFileInfoPartV2(this.file.length(), (long)this.config.chunkSize, this.file.lastModified());
    }

    @Override
    void serverInit(final PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        final UploadFileInfoPartV2 uploadFileInfo = (UploadFileInfoPartV2)this.fileInfo;
        if (uploadFileInfo != null && uploadFileInfo.isValid()) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " serverInit success");
            ResponseInfo responseInfo = ResponseInfo.successResponse();
            completeHandler.complete(responseInfo, null, null);
            return;
        }
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.initPart(true, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                PartsUploadPerformerV2.this.destroyUploadRequestTransaction(transaction);
                String uploadId = null;
                Long expireAt = null;
                if (response != null) {
                    try {
                        uploadId = response.getString("uploadId");
                        expireAt = response.getLong("expireAt");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (responseInfo.isOK() && uploadId != null && expireAt != null) {
                    uploadFileInfo.uploadId = uploadId;
                    uploadFileInfo.expireAt = expireAt;
                    PartsUploadPerformerV2.this.recordUploadInfo();
                }
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void uploadNextData(final PartsUploadPerformer.PartsUploadPerformerDataCompleteHandler completeHandler) {
        ResponseInfo responseInfo;
        UploadFileInfoPartV2 uploadFileInfo = (UploadFileInfoPartV2)this.fileInfo;
        UploadData data = null;
        PartsUploadPerformerV2 partsUploadPerformerV2 = this;
        synchronized (partsUploadPerformerV2) {
            data = uploadFileInfo.nextUploadData();
            if (data != null) {
                data.isUploading = true;
                data.isCompleted = false;
            }
        }
        if (data == null) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " no data left");
            responseInfo = ResponseInfo.sdkInteriorError("no data left");
            completeHandler.complete(true, responseInfo, null, null);
            return;
        }
        data.data = this.getUploadData(data);
        if (data.data == null) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " get data error");
            data.isUploading = false;
            data.isCompleted = false;
            responseInfo = ResponseInfo.localIOError("get data error");
            completeHandler.complete(true, responseInfo, null, responseInfo.response);
            return;
        }
        final UploadData uploadData = data;
        RequestProgressHandler progressHandler = new RequestProgressHandler(){

            @Override
            public void progress(long totalBytesWritten, long totalBytesExpectedToWrite) {
                uploadData.progress = (double)totalBytesWritten / (double)totalBytesExpectedToWrite;
                PartsUploadPerformerV2.this.notifyProgress();
            }
        };
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.uploadPart(true, uploadFileInfo.uploadId, data.index, data.data, progressHandler, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                uploadData.data = null;
                PartsUploadPerformerV2.this.destroyUploadRequestTransaction(transaction);
                String etag = null;
                String md5 = null;
                if (response != null) {
                    try {
                        etag = response.getString("etag");
                        md5 = response.getString("md5");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (responseInfo.isOK() && etag != null && md5 != null) {
                    uploadData.progress = 1.0;
                    uploadData.etag = etag;
                    uploadData.isUploading = false;
                    uploadData.isCompleted = true;
                    PartsUploadPerformerV2.this.recordUploadInfo();
                    PartsUploadPerformerV2.this.notifyProgress();
                } else {
                    uploadData.isUploading = false;
                    uploadData.isCompleted = false;
                }
                completeHandler.complete(false, responseInfo, requestMetrics, response);
            }
        });
    }

    @Override
    void completeUpload(final PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        UploadFileInfoPartV2 uploadFileInfo = (UploadFileInfoPartV2)this.fileInfo;
        List<Map<String, Object>> partInfoArray = uploadFileInfo.getPartInfoArray();
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.completeParts(true, this.fileName, uploadFileInfo.uploadId, partInfoArray, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                PartsUploadPerformerV2.this.destroyUploadRequestTransaction(transaction);
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getUploadData(UploadData data) {
        if (this.randomAccessFile == null || data == null) {
            return null;
        }
        byte[] uploadData = new byte[(int)data.size];
        try {
            RandomAccessFile randomAccessFile = this.randomAccessFile;
            synchronized (randomAccessFile) {
                this.randomAccessFile.seek(data.offset);
                this.randomAccessFile.read(uploadData, 0, (int)data.size);
            }
        }
        catch (IOException e) {
            uploadData = null;
        }
        return uploadData;
    }
}

