/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.storage.UploadData;
import com.qiniu.android.storage.UploadFileInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UploadFileInfoPartV2
extends UploadFileInfo {
    final ArrayList<UploadData> uploadDataList;
    String uploadId;
    Long expireAt;

    private UploadFileInfoPartV2(long size, long modifyTime, ArrayList<UploadData> uploadDataList) {
        super(size, modifyTime);
        this.uploadDataList = uploadDataList;
    }

    UploadFileInfoPartV2(long size, long dataSize, long modifyTime) {
        super(size, modifyTime);
        this.uploadDataList = this.createDataList(dataSize);
    }

    static UploadFileInfoPartV2 fileFromJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        long size = 0L;
        long modifyTime = 0L;
        Long expireAt = null;
        String uploadId = null;
        ArrayList<UploadData> uploadDataList = new ArrayList<UploadData>();
        try {
            size = jsonObject.getLong("size");
            modifyTime = jsonObject.getLong("modifyTime");
            expireAt = jsonObject.getLong("expireAt");
            uploadId = jsonObject.getString("uploadId");
            JSONArray dataJsonArray = jsonObject.getJSONArray("uploadDataList");
            for (int i = 0; i < dataJsonArray.length(); ++i) {
                JSONObject dataJson = dataJsonArray.getJSONObject(i);
                UploadData data = UploadData.dataFromJson(dataJson);
                if (data == null) continue;
                uploadDataList.add(data);
            }
        }
        catch (JSONException dataJsonArray) {
            // empty catch block
        }
        UploadFileInfoPartV2 fileInfo = new UploadFileInfoPartV2(size, modifyTime, uploadDataList);
        fileInfo.expireAt = expireAt;
        fileInfo.uploadId = uploadId;
        return fileInfo;
    }

    private ArrayList<UploadData> createDataList(long dataSize) {
        long offset = 0L;
        int dataIndex = 1;
        ArrayList<UploadData> dataList = new ArrayList<UploadData>();
        while (offset < this.size) {
            long lastSize = this.size - offset;
            long dataSizeP = Math.min(lastSize, dataSize);
            UploadData data = new UploadData(offset, dataSizeP, dataIndex);
            if (data == null) continue;
            dataList.add(data);
            offset += dataSizeP;
            ++dataIndex;
        }
        return dataList;
    }

    @Override
    double progress() {
        if (this.uploadDataList == null) {
            return 0.0;
        }
        double progress = 0.0;
        for (UploadData data : this.uploadDataList) {
            progress += data.progress * ((double)data.size / (double)this.size);
        }
        return progress;
    }

    @Override
    boolean isEmpty() {
        return this.uploadDataList == null || this.uploadDataList.size() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean isValid() {
        if (this.isEmpty()) return false;
        if (this.uploadId == null) return false;
        Date date = new Date();
        if (!((double)this.expireAt.longValue() - (double)date.getTime() * 0.001 > 86400.0)) return false;
        return true;
    }

    UploadData nextUploadData() {
        if (this.uploadDataList == null || this.uploadDataList.size() == 0) {
            return null;
        }
        UploadData data = null;
        for (UploadData dataP : this.uploadDataList) {
            if (dataP.isCompleted || dataP.isUploading) continue;
            data = dataP;
            break;
        }
        return data;
    }

    @Override
    void clearUploadState() {
        for (UploadData data : this.uploadDataList) {
            data.clearUploadState();
        }
    }

    @Override
    boolean isAllUploaded() {
        if (this.uploadDataList == null || this.uploadDataList.size() == 0) {
            return true;
        }
        boolean isCompleted = true;
        for (UploadData data : this.uploadDataList) {
            if (data.isCompleted) continue;
            isCompleted = false;
            break;
        }
        return isCompleted;
    }

    List<Map<String, Object>> getPartInfoArray() {
        if (this.uploadId == null || this.uploadId.length() == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> infoArray = new ArrayList<Map<String, Object>>();
        for (UploadData data : this.uploadDataList) {
            if (data.etag == null) continue;
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put("etag", data.etag);
            info.put("partNumber", data.index);
            infoArray.add(info);
        }
        return infoArray;
    }

    @Override
    JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("size", this.size);
            jsonObject.put("modifyTime", this.modifyTime);
            jsonObject.put("expireAt", (Object)this.expireAt);
            jsonObject.put("uploadId", (Object)this.uploadId);
            if (this.uploadDataList != null && this.uploadDataList.size() > 0) {
                JSONArray dataJsonArray = new JSONArray();
                for (UploadData data : this.uploadDataList) {
                    JSONObject dataJson = data.toJsonObject();
                    if (dataJson == null) continue;
                    dataJsonArray.put((Object)dataJson);
                }
                jsonObject.put("uploadDataList", (Object)dataJsonArray);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

