/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.dns;

import com.qiniu.android.common.Config;
import com.qiniu.android.common.FixedZone;
import com.qiniu.android.common.Zone;
import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.common.ZonesInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.Dns;
import com.qiniu.android.http.dns.DnsCacheFile;
import com.qiniu.android.http.dns.DnsCacheInfo;
import com.qiniu.android.http.dns.DnsNetworkAddress;
import com.qiniu.android.http.dns.HappyDns;
import com.qiniu.android.http.dns.IDnsNetworkAddress;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.storage.GlobalConfiguration;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.AndroidNetwork;
import com.qiniu.android.utils.Utils;
import com.qiniu.android.utils.Wait;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DnsPrefetcher {
    private boolean isPrefetching = false;
    private DnsCacheInfo dnsCacheInfo = null;
    private ConcurrentHashMap<String, List<IDnsNetworkAddress>> addressDictionary = new ConcurrentHashMap();
    private final HappyDns happyDns = new HappyDns();
    private static final DnsPrefetcher dnsPrefetcher = new DnsPrefetcher();
    public String lastPrefetchErrorMessage;

    private DnsPrefetcher() {
        this.happyDns.setQueryErrorHandler(new HappyDns.DnsQueryErrorHandler(){

            public void queryError(Exception e, String host) {
                DnsPrefetcher.this.lastPrefetchErrorMessage = e.getMessage();
            }
        });
    }

    public static DnsPrefetcher getInstance() {
        return dnsPrefetcher;
    }

    public boolean recoverCache() {
        DnsCacheFile recorder = null;
        try {
            recorder = new DnsCacheFile(GlobalConfiguration.getInstance().dnsCacheDir);
        }
        catch (IOException e) {
            return true;
        }
        String localIp = AndroidNetwork.getHostIP();
        if (localIp == null || localIp.length() == 0) {
            return true;
        }
        byte[] data = recorder.get(localIp);
        if (data == null) {
            return true;
        }
        return this.recoverDnsCache(data);
    }

    public void localFetch() {
        if (!this.prepareToPreFetch()) {
            return;
        }
        this.preFetchHosts(this.getLocalPreHost());
        this.recorderDnsCache();
        this.endPreFetch();
    }

    public boolean checkAndPrefetchDnsIfNeed(Zone currentZone, UpToken token) {
        if (!this.prepareToPreFetch()) {
            return false;
        }
        this.preFetchHosts(this.getCurrentZoneHosts(currentZone, token));
        this.recorderDnsCache();
        this.endPreFetch();
        return true;
    }

    public void invalidNetworkAddress(IDnsNetworkAddress address) {
        if (address == null || address.getHostValue() == null) {
            return;
        }
        String host = address.getHostValue();
        List<IDnsNetworkAddress> addressList = this.addressDictionary.get(host);
        ArrayList<IDnsNetworkAddress> addressListNew = new ArrayList<IDnsNetworkAddress>();
        for (IDnsNetworkAddress addressP : addressList) {
            if (addressP.getIpValue().equals(addressP.getIpValue())) continue;
            addressListNew.add(addressP);
        }
        this.addressDictionary.put(host, addressListNew);
    }

    public List<IDnsNetworkAddress> getInetAddressByHost(String host) {
        if (!this.isDnsOpen()) {
            return null;
        }
        List<IDnsNetworkAddress> addressList = this.addressDictionary.get(host);
        if (addressList != null && addressList.size() > 0) {
            return addressList;
        }
        return null;
    }

    public void checkWhetherCachedDnsValid() {
        if (!this.prepareToPreFetch()) {
            return;
        }
        this.preFetchHosts(this.addressDictionary.keySet().toArray(new String[0]));
        this.recorderDnsCache();
        this.endPreFetch();
    }

    private synchronized boolean prepareToPreFetch() {
        if (!this.isDnsOpen()) {
            return false;
        }
        if (this.isPrefetching()) {
            return false;
        }
        String localIp = AndroidNetwork.getHostIP();
        if (localIp == null || this.getDnsCacheInfo() == null || !localIp.equals(this.getDnsCacheInfo().getLocalIp())) {
            this.clearPreHosts();
        }
        this.setPrefetching(true);
        return true;
    }

    private void endPreFetch() {
        this.setPrefetching(false);
    }

    private void preFetchHosts(String[] fetchHosts) {
        String[] nextFetchHosts = fetchHosts;
        nextFetchHosts = this.preFetchHosts(nextFetchHosts, GlobalConfiguration.getInstance().dns);
        nextFetchHosts = this.preFetchHosts(nextFetchHosts, this.happyDns);
    }

    private String[] preFetchHosts(String[] preHosts, Dns dns) {
        if (preHosts == null || preHosts.length == 0) {
            return null;
        }
        if (dns == null) {
            return preHosts;
        }
        ArrayList<String> failHosts = new ArrayList<String>();
        for (String host : preHosts) {
            boolean isSuccess = false;
            for (int rePreNum = 0; rePreNum < GlobalConfiguration.getInstance().dnsRepreHostNum; ++rePreNum) {
                if (!this.preFetchHost(host, dns)) continue;
                isSuccess = true;
                break;
            }
            if (isSuccess) continue;
            failHosts.add(host);
        }
        return failHosts.toArray(new String[0]);
    }

    private boolean preFetchHost(String preHost, Dns dns) {
        if (preHost == null || preHost.length() == 0) {
            return false;
        }
        List<IDnsNetworkAddress> preAddressList = this.addressDictionary.get(preHost);
        if (preAddressList != null && preAddressList.size() > 0) {
            return true;
        }
        ArrayList<DnsNetworkAddress> addressList = new ArrayList<DnsNetworkAddress>();
        try {
            List<IDnsNetworkAddress> preIAddressList = dns.lookup(preHost);
            if (preIAddressList != null && preIAddressList.size() > 0) {
                for (IDnsNetworkAddress preIAddress : preIAddressList) {
                    DnsNetworkAddress address = new DnsNetworkAddress(preIAddress.getHostValue(), preIAddress.getIpValue(), preIAddress.getTtlValue() != null ? preIAddress.getTtlValue() : (long)GlobalConfiguration.getInstance().dnsCacheTime, preIAddress.getSourceValue(), preIAddress.getTimestampValue());
                    addressList.add(address);
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (addressList != null && addressList.size() > 0) {
            this.addressDictionary.put(preHost, addressList);
            return true;
        }
        return false;
    }

    private boolean recoverDnsCache(byte[] data) {
        DnsCacheInfo dnsCacheInfo = DnsCacheInfo.createDnsCacheInfoByData(data);
        if (dnsCacheInfo == null || dnsCacheInfo.getInfo() == null || dnsCacheInfo.getInfo().size() == 0) {
            return false;
        }
        this.addressDictionary.putAll(dnsCacheInfo.getInfo());
        dnsCacheInfo.setInfo(this.addressDictionary);
        this.setDnsCacheInfo(dnsCacheInfo);
        return false;
    }

    private boolean recorderDnsCache() {
        String currentTime = Utils.currentTimestamp() + "";
        String localIp = AndroidNetwork.getHostIP();
        if (localIp == null) {
            return false;
        }
        DnsCacheInfo dnsCacheInfo = new DnsCacheInfo(currentTime, localIp, this.addressDictionary);
        DnsCacheFile recorder = null;
        try {
            recorder = new DnsCacheFile(GlobalConfiguration.getInstance().dnsCacheDir);
        }
        catch (IOException e) {
            return false;
        }
        this.setDnsCacheInfo(dnsCacheInfo);
        byte[] data = dnsCacheInfo.toJsonData();
        if (data == null) {
            return false;
        }
        recorder.set(dnsCacheInfo.cacheKey(), data);
        return true;
    }

    private void clearPreHosts() {
        this.addressDictionary.clear();
    }

    private String[] getLocalPreHost() {
        ArrayList<String> localHosts = new ArrayList<String>();
        String[] fixedHosts = this.getFixedZoneHosts();
        localHosts.addAll(Arrays.asList(fixedHosts));
        localHosts.add(Config.preQueryHost00);
        localHosts.add(Config.preQueryHost01);
        String logReport = "uplog.qbox.me";
        localHosts.add(logReport);
        return localHosts.toArray(new String[0]);
    }

    private String[] getCurrentZoneHosts(Zone currentZone, UpToken token) {
        if (currentZone == null || token == null) {
            return null;
        }
        final Wait wait = new Wait();
        currentZone.preQuery(token, new Zone.QueryHandler(){

            @Override
            public void complete(int code, ResponseInfo responseInfo, UploadRegionRequestMetrics metrics) {
                wait.stopWait();
            }
        });
        wait.startWait();
        ZonesInfo autoZonesInfo = currentZone.getZonesInfo(token);
        ArrayList<String> autoHosts = new ArrayList<String>();
        if (autoZonesInfo != null && autoZonesInfo.zonesInfo != null && autoZonesInfo.zonesInfo.size() > 0) {
            for (ZoneInfo zoneInfo : autoZonesInfo.zonesInfo) {
                if (zoneInfo == null || zoneInfo.allHosts == null) continue;
                autoHosts.addAll(zoneInfo.allHosts);
            }
        }
        return autoHosts.toArray(new String[0]);
    }

    private String[] getFixedZoneHosts() {
        ArrayList<String> localHosts = new ArrayList<String>();
        FixedZone fixedZone = FixedZone.localsZoneInfo();
        ZonesInfo zonesInfo = fixedZone.getZonesInfo(null);
        for (ZoneInfo zoneInfo : zonesInfo.zonesInfo) {
            if (zoneInfo == null || zoneInfo.allHosts == null) continue;
            localHosts.addAll(zoneInfo.allHosts);
        }
        return localHosts.toArray(new String[0]);
    }

    private String[] getCacheHosts() {
        return this.addressDictionary.keySet().toArray(new String[0]);
    }

    public boolean isDnsOpen() {
        return GlobalConfiguration.getInstance().isDnsOpen;
    }

    public synchronized boolean isPrefetching() {
        return this.isPrefetching;
    }

    private synchronized void setPrefetching(boolean isPrefetching) {
        this.isPrefetching = isPrefetching;
    }

    private synchronized DnsCacheInfo getDnsCacheInfo() {
        return this.dnsCacheInfo;
    }

    private synchronized void setDnsCacheInfo(DnsCacheInfo dnsCacheInfo) {
        this.dnsCacheInfo = dnsCacheInfo;
    }
}

