/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.networkStatus;

import com.qiniu.android.storage.FileRecorder;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.Utils;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class NetworkStatusManager {
    private static String kNetworkStatusDiskKey = "NetworkStatus:v1.0.0";
    private boolean hasInit = false;
    private boolean isHandlingNetworkInfoOfDisk = false;
    private Recorder recorder;
    private ConcurrentHashMap<String, NetworkStatus> networkStatusInfo;
    private static NetworkStatusManager networkStatusManager = new NetworkStatusManager();

    public static NetworkStatusManager getInstance() {
        networkStatusManager.initData();
        return networkStatusManager;
    }

    public synchronized void initData() {
        if (this.hasInit) {
            return;
        }
        NetworkStatusManager.networkStatusManager.networkStatusInfo = new ConcurrentHashMap();
        networkStatusManager.asyncRecoverNetworkStatusFromDisk();
    }

    public static String getNetworkStatusType(String host, String ip) {
        return Utils.getIpType(ip, host);
    }

    public NetworkStatus getNetworkStatus(String type) {
        if (type == null || type.length() == 0) {
            return null;
        }
        NetworkStatus status = this.networkStatusInfo.get(type);
        if (status == null) {
            status = new NetworkStatus();
        }
        return status;
    }

    public void updateNetworkStatus(String type, int speed) {
        if (type == null || type.length() == 0) {
            return;
        }
        NetworkStatus status = this.networkStatusInfo.get(type);
        if (status == null) {
            status = new NetworkStatus();
            this.networkStatusInfo.put(type, status);
        }
        status.setSpeed(speed);
        this.asyncRecordNetworkStatusInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncRecordNetworkStatusInfo() {
        NetworkStatusManager networkStatusManager = this;
        synchronized (networkStatusManager) {
            if (this.isHandlingNetworkInfoOfDisk) {
                return;
            }
            this.isHandlingNetworkInfoOfDisk = true;
        }
        AsyncRun.runInBack(new Runnable(){

            @Override
            public void run() {
                NetworkStatusManager.this.recordNetworkStatusInfo();
                NetworkStatusManager.this.isHandlingNetworkInfoOfDisk = false;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncRecoverNetworkStatusFromDisk() {
        NetworkStatusManager networkStatusManager = this;
        synchronized (networkStatusManager) {
            if (this.isHandlingNetworkInfoOfDisk) {
                return;
            }
            this.isHandlingNetworkInfoOfDisk = true;
        }
        AsyncRun.runInBack(new Runnable(){

            @Override
            public void run() {
                NetworkStatusManager.this.recoverNetworkStatusFromDisk();
                NetworkStatusManager.this.isHandlingNetworkInfoOfDisk = true;
            }
        });
    }

    private void recordNetworkStatusInfo() {
        this.setupRecorder();
        if (this.recorder == null || this.networkStatusInfo == null) {
            return;
        }
        JSONObject networkStatusInfoJson = new JSONObject();
        for (String key : this.networkStatusInfo.keySet()) {
            NetworkStatus status = this.networkStatusInfo.get(key);
            if (status == null) continue;
            try {
                networkStatusInfoJson.put(key, (Object)status.toJson());
            }
            catch (Exception exception) {}
        }
        this.recorder.set(kNetworkStatusDiskKey, networkStatusInfoJson.toString().getBytes());
    }

    private void recoverNetworkStatusFromDisk() {
        this.setupRecorder();
        if (this.recorder == null || this.networkStatusInfo == null) {
            return;
        }
        byte[] networkStatusInfoData = this.recorder.get(kNetworkStatusDiskKey);
        JSONObject networkStatusInfoJSON = null;
        try {
            networkStatusInfoJSON = new JSONObject(new String(networkStatusInfoData));
        }
        catch (Exception ignored) {
            return;
        }
        Iterator it = networkStatusInfoJSON.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            try {
                JSONObject statusJson = networkStatusInfoJSON.getJSONObject(key);
                NetworkStatus status = NetworkStatus.statusFromJson(statusJson);
                if (status == null) continue;
                this.networkStatusInfo.put(key, status);
            }
            catch (JSONException jSONException) {}
        }
    }

    private synchronized void setupRecorder() {
        if (this.recorder == null) {
            try {
                this.recorder = new FileRecorder(Utils.sdkDirectory() + "/NetworkInfo");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class NetworkStatus {
        private int speed;

        public int getSpeed() {
            return this.speed;
        }

        public void setSpeed(int speed) {
            this.speed = speed;
        }

        private JSONObject toJson() {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject.put("speed", this.speed);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return jsonObject;
        }

        private static NetworkStatus statusFromJson(JSONObject jsonObject) {
            if (jsonObject == null) {
                return null;
            }
            NetworkStatus status = new NetworkStatus();
            try {
                status.speed = jsonObject.getInt("speed");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return status;
        }
    }
}

