/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.PartsUploadPerformer;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadBlock;
import com.qiniu.android.storage.UploadData;
import com.qiniu.android.storage.UploadFileInfo;
import com.qiniu.android.storage.UploadFileInfoPartV1;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

class PartsUploadPerformerV1
extends PartsUploadPerformer {
    private static long BlockSize = 0x400000L;

    PartsUploadPerformerV1(File file, String fileName, String key, UpToken token, UploadOptions options, Configuration config, String recorderKey) {
        super(file, fileName, key, token, options, config, recorderKey);
    }

    @Override
    UploadFileInfo getFileFromJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return UploadFileInfoPartV1.fileFromJson(jsonObject);
    }

    @Override
    UploadFileInfo getDefaultUploadFileInfo() {
        return new UploadFileInfoPartV1(this.file.length(), BlockSize, this.getUploadChunkSize(), this.file.lastModified());
    }

    @Override
    void serverInit(PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        ResponseInfo responseInfo = ResponseInfo.successResponse();
        completeHandler.complete(responseInfo, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void uploadNextData(final PartsUploadPerformer.PartsUploadPerformerDataCompleteHandler completeHandler) {
        ResponseInfo responseInfo;
        UploadFileInfoPartV1 uploadFileInfo = (UploadFileInfoPartV1)this.fileInfo;
        UploadBlock block = null;
        UploadData chunk = null;
        PartsUploadPerformerV1 partsUploadPerformerV1 = this;
        synchronized (partsUploadPerformerV1) {
            block = uploadFileInfo.nextUploadBlock();
            if (block != null && (chunk = block.nextUploadData()) != null) {
                chunk.isUploading = true;
                chunk.isCompleted = false;
            }
        }
        if (block == null || chunk == null) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " no chunk left");
            responseInfo = ResponseInfo.sdkInteriorError("no chunk left");
            completeHandler.complete(true, responseInfo, null, null);
            return;
        }
        chunk.data = this.getDataWithChunk(chunk, block);
        if (chunk.data == null) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " no chunk left");
            chunk.isUploading = false;
            chunk.isCompleted = false;
            responseInfo = ResponseInfo.localIOError("get data error");
            completeHandler.complete(true, responseInfo, null, null);
            return;
        }
        final UploadBlock uploadBlock = block;
        final UploadData uploadChunk = chunk;
        RequestProgressHandler progressHandler = new RequestProgressHandler(){

            @Override
            public void progress(long totalBytesWritten, long totalBytesExpectedToWrite) {
                uploadChunk.progress = (double)totalBytesWritten / (double)totalBytesExpectedToWrite;
                PartsUploadPerformerV1.this.notifyProgress();
            }
        };
        PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandlerP = new PartsUploadPerformer.PartsUploadPerformerCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                uploadChunk.data = null;
                String blockContext = null;
                if (response != null) {
                    try {
                        blockContext = response.getString("ctx");
                    }
                    catch (JSONException jSONException) {
                        // empty catch block
                    }
                }
                if (responseInfo.isOK() && blockContext != null) {
                    uploadBlock.context = blockContext;
                    uploadChunk.progress = 1.0;
                    uploadChunk.isUploading = false;
                    uploadChunk.isCompleted = true;
                    PartsUploadPerformerV1.this.recordUploadInfo();
                    PartsUploadPerformerV1.this.notifyProgress();
                } else {
                    uploadChunk.isUploading = false;
                    uploadChunk.isCompleted = false;
                }
                completeHandler.complete(false, responseInfo, requestMetrics, response);
            }
        };
        if (uploadChunk.isFirstData()) {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " makeBlock");
            this.makeBlock(uploadBlock, uploadChunk, progressHandler, completeHandlerP);
        } else {
            LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " makeBlock");
            this.uploadChunk(uploadBlock, uploadChunk, progressHandler, completeHandlerP);
        }
    }

    @Override
    void completeUpload(final PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        UploadFileInfoPartV1 uploadFileInfo = (UploadFileInfoPartV1)this.fileInfo;
        String[] contexts = null;
        ArrayList<String> contextsList = uploadFileInfo.allBlocksContexts();
        if (contextsList != null && contextsList.size() > 0) {
            contexts = contextsList.toArray(new String[contextsList.size()]);
        }
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.makeFile(uploadFileInfo.size, this.fileName, contexts, true, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                PartsUploadPerformerV1.this.destroyUploadRequestTransaction(transaction);
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }

    private void makeBlock(UploadBlock block, UploadData chunk, RequestProgressHandler progressHandler, final PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.makeBlock(block.offset, block.size, chunk.data, true, progressHandler, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                PartsUploadPerformerV1.this.destroyUploadRequestTransaction(transaction);
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }

    private void uploadChunk(UploadBlock block, UploadData chunk, RequestProgressHandler progressHandler, final PartsUploadPerformer.PartsUploadPerformerCompleteHandler completeHandler) {
        final RequestTransaction transaction = this.createUploadRequestTransaction();
        transaction.uploadChunk(block.context, block.offset, chunk.data, chunk.offset, true, progressHandler, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                PartsUploadPerformerV1.this.destroyUploadRequestTransaction(transaction);
                completeHandler.complete(responseInfo, requestMetrics, response);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getDataWithChunk(UploadData chunk, UploadBlock block) {
        if (this.randomAccessFile == null || chunk == null || block == null) {
            return null;
        }
        byte[] data = new byte[(int)chunk.size];
        try {
            RandomAccessFile randomAccessFile = this.randomAccessFile;
            synchronized (randomAccessFile) {
                this.randomAccessFile.seek(chunk.offset + block.offset);
                this.randomAccessFile.read(data, 0, (int)chunk.size);
            }
        }
        catch (IOException e) {
            data = null;
        }
        return data;
    }

    private long getUploadChunkSize() {
        if (this.config.useConcurrentResumeUpload) {
            return BlockSize;
        }
        return this.config.chunkSize;
    }
}

