/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.storage.UploadData;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class UploadBlock {
    final long offset;
    final long size;
    final int index;
    final ArrayList<UploadData> uploadDataList;
    String context;

    UploadBlock(long offset, long blockSize, long dataSize, int index) {
        this.offset = offset;
        this.size = blockSize;
        this.index = index;
        this.uploadDataList = this.createDataList(dataSize);
    }

    private UploadBlock(long offset, long blockSize, int index, ArrayList<UploadData> uploadDataList) {
        this.offset = offset;
        this.size = blockSize;
        this.index = index;
        this.uploadDataList = uploadDataList;
    }

    static UploadBlock blockFromJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        long offset = 0L;
        long size = 0L;
        int index = 0;
        String context = null;
        ArrayList<UploadData> uploadDataList = new ArrayList<UploadData>();
        try {
            offset = jsonObject.getLong("offset");
            size = jsonObject.getLong("size");
            index = jsonObject.getInt("index");
            context = jsonObject.getString("context");
            JSONArray dataJsonArray = jsonObject.getJSONArray("uploadDataList");
            for (int i = 0; i < dataJsonArray.length(); ++i) {
                JSONObject dataJson = dataJsonArray.getJSONObject(i);
                UploadData data = UploadData.dataFromJson(dataJson);
                if (data == null) continue;
                uploadDataList.add(data);
            }
        }
        catch (JSONException dataJsonArray) {
            // empty catch block
        }
        UploadBlock block = new UploadBlock(offset, size, index, uploadDataList);
        if (context != null && context.length() > 0) {
            block.context = context;
        }
        return block;
    }

    boolean isCompleted() {
        if (this.uploadDataList == null) {
            return true;
        }
        boolean isCompleted = true;
        for (UploadData data : this.uploadDataList) {
            if (data.isCompleted) continue;
            isCompleted = false;
            break;
        }
        return isCompleted;
    }

    double progress() {
        if (this.uploadDataList == null) {
            return 0.0;
        }
        double progress = 0.0;
        for (UploadData data : this.uploadDataList) {
            progress += data.progress * ((double)data.size / (double)this.size);
        }
        return progress;
    }

    private ArrayList<UploadData> createDataList(long dataSize) {
        long offset = 0L;
        int dataIndex = 1;
        ArrayList<UploadData> datas = new ArrayList<UploadData>();
        while (offset < this.size) {
            long lastSize = this.size - offset;
            long dataSizeP = Math.min(lastSize, dataSize);
            UploadData data = new UploadData(offset, dataSizeP, dataIndex);
            if (data == null) continue;
            datas.add(data);
            offset += dataSizeP;
            ++dataIndex;
        }
        return datas;
    }

    JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("offset", this.offset);
            jsonObject.put("size", this.size);
            jsonObject.put("index", this.index);
            jsonObject.put("context", (Object)(this.context != null ? this.context : ""));
            if (this.uploadDataList != null && this.uploadDataList.size() > 0) {
                JSONArray dataJsonArray = new JSONArray();
                for (UploadData data : this.uploadDataList) {
                    JSONObject dataJson = data.toJsonObject();
                    if (dataJson == null) continue;
                    dataJsonArray.put((Object)dataJson);
                }
                jsonObject.put("uploadDataList", (Object)dataJsonArray);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    protected UploadData nextUploadData() {
        if (this.uploadDataList == null || this.uploadDataList.size() == 0) {
            return null;
        }
        UploadData data = null;
        for (UploadData dataP : this.uploadDataList) {
            if (dataP.isCompleted || dataP.isUploading) continue;
            data = dataP;
            break;
        }
        return data;
    }

    protected void clearUploadState() {
        this.context = null;
        if (this.uploadDataList == null || this.uploadDataList.size() == 0) {
            return;
        }
        for (UploadData data : this.uploadDataList) {
            data.clearUploadState();
        }
    }
}

