/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import org.json.JSONException;
import org.json.JSONObject;

class UploadData {
    final long offset;
    final long size;
    final int index;
    String etag;
    boolean isCompleted;
    boolean isUploading;
    double progress;
    byte[] data;

    UploadData(long offset, long size, int index) {
        this.offset = offset;
        this.size = size;
        this.index = index;
        this.isCompleted = false;
        this.isUploading = false;
        this.progress = 0.0;
    }

    static UploadData dataFromJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        long offset = 0L;
        long size = 0L;
        int index = 0;
        String etag = null;
        boolean isCompleted = false;
        double progress = 0.0;
        try {
            offset = jsonObject.getLong("offset");
            size = jsonObject.getLong("size");
            index = jsonObject.getInt("index");
            isCompleted = jsonObject.getBoolean("isCompleted");
            progress = jsonObject.getDouble("progress");
            etag = jsonObject.getString("etag");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        UploadData uploadData = new UploadData(offset, size, index);
        uploadData.isCompleted = isCompleted;
        uploadData.progress = progress;
        uploadData.etag = etag;
        return uploadData;
    }

    boolean isFirstData() {
        return this.index == 1;
    }

    void clearUploadState() {
        this.etag = null;
        this.isCompleted = false;
        this.isUploading = false;
    }

    JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("offset", this.offset);
            jsonObject.put("size", this.size);
            jsonObject.put("index", this.index);
            jsonObject.put("isCompleted", this.isCompleted);
            jsonObject.put("progress", this.progress);
            jsonObject.put("etag", (Object)this.etag);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return jsonObject;
    }
}

