/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.common.Zone;
import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.common.ZonesInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.metrics.UploadTaskMetrics;
import com.qiniu.android.http.request.IUploadRegion;
import com.qiniu.android.http.serverRegion.UploadDomainRegion;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import java.io.File;
import java.util.ArrayList;
import org.json.JSONObject;

abstract class BaseUpload
implements Runnable {
    protected final String key;
    protected final String fileName;
    protected final byte[] data;
    protected final File file;
    protected final UpToken token;
    protected final UploadOptions option;
    protected final Configuration config;
    protected final Recorder recorder;
    protected final String recorderKey;
    protected final UpTaskCompletionHandler completionHandler;
    private UploadRegionRequestMetrics currentRegionRequestMetrics;
    private UploadTaskMetrics metrics = new UploadTaskMetrics(null);
    private int currentRegionIndex;
    private ArrayList<IUploadRegion> regions;

    private BaseUpload(File file, byte[] data, String fileName, String key, UpToken token, UploadOptions option, Configuration config, Recorder recorder, String recorderKey, UpTaskCompletionHandler completionHandler) {
        this.file = file;
        this.data = data;
        this.fileName = fileName != null ? fileName : "?";
        this.key = key;
        this.token = token;
        this.option = option != null ? option : UploadOptions.defaultOptions();
        this.config = config;
        this.recorder = recorder;
        this.recorderKey = recorderKey;
        this.completionHandler = completionHandler;
        this.initData();
    }

    protected BaseUpload(File file, String key, UpToken token, UploadOptions option, Configuration config, Recorder recorder, String recorderKey, UpTaskCompletionHandler completionHandler) {
        this(file, null, file.getName(), key, token, option, config, recorder, recorderKey, completionHandler);
    }

    protected BaseUpload(byte[] data, String key, String fileName, UpToken token, UploadOptions option, Configuration config, UpTaskCompletionHandler completionHandler) {
        this(null, data, fileName, key, token, option, config, null, null, completionHandler);
    }

    protected void initData() {
        this.currentRegionIndex = 0;
    }

    @Override
    public void run() {
        this.config.zone.preQuery(this.token, new Zone.QueryHandler(){

            @Override
            public void complete(int code, ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics) {
                BaseUpload.this.metrics.addMetrics(requestMetrics);
                if (code == 0) {
                    int prepareCode = BaseUpload.this.prepareToUpload();
                    if (prepareCode == 0) {
                        BaseUpload.this.startToUpload();
                    } else {
                        ResponseInfo responseInfoP = ResponseInfo.errorInfo(prepareCode, null);
                        BaseUpload.this.completeAction(responseInfoP, null);
                    }
                } else {
                    BaseUpload.this.completeAction(responseInfo, responseInfo.response);
                }
            }
        });
    }

    protected int prepareToUpload() {
        int ret = 0;
        if (!this.setupRegions()) {
            ret = -1;
        }
        return ret;
    }

    protected abstract void startToUpload();

    protected boolean switchRegionAndUpload() {
        boolean isSwitched;
        if (this.currentRegionRequestMetrics != null) {
            this.metrics.addMetrics(this.currentRegionRequestMetrics);
            this.currentRegionRequestMetrics = null;
        }
        if (isSwitched = this.switchRegion()) {
            this.startToUpload();
        }
        return isSwitched;
    }

    protected void completeAction(ResponseInfo responseInfo, JSONObject response) {
        if (this.currentRegionRequestMetrics != null && this.metrics != null) {
            this.metrics.addMetrics(this.currentRegionRequestMetrics);
        }
        if (this.completionHandler != null) {
            this.completionHandler.complete(responseInfo, this.key, this.metrics, response);
        }
        this.metrics = null;
        this.currentRegionRequestMetrics = null;
    }

    private boolean setupRegions() {
        if (this.config == null || this.config.zone == null) {
            return false;
        }
        ZonesInfo zonesInfo = this.config.zone.getZonesInfo(this.token);
        if (zonesInfo == null || zonesInfo.zonesInfo == null || zonesInfo.zonesInfo.size() == 0) {
            return false;
        }
        ArrayList<ZoneInfo> zoneInfos = zonesInfo.zonesInfo;
        ArrayList<UploadDomainRegion> defaultRegions = new ArrayList<UploadDomainRegion>();
        for (ZoneInfo zoneInfo : zoneInfos) {
            UploadDomainRegion region = new UploadDomainRegion();
            region.setupRegionData(zoneInfo);
            if (!region.isValid()) continue;
            defaultRegions.add(region);
        }
        this.regions = defaultRegions;
        this.metrics.regions = defaultRegions;
        return defaultRegions.size() > 0;
    }

    protected void insertRegionAtFirst(IUploadRegion region) {
        if (region == null) {
            return;
        }
        boolean hasRegion = false;
        for (IUploadRegion regionP : this.regions) {
            if (!region.isEqual(regionP)) continue;
            hasRegion = true;
            break;
        }
        if (!hasRegion) {
            this.regions.add(0, region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean switchRegion() {
        if (this.regions == null) {
            return false;
        }
        boolean ret = false;
        BaseUpload baseUpload = this;
        synchronized (baseUpload) {
            int regionIndex = this.currentRegionIndex + 1;
            if (regionIndex < this.regions.size()) {
                this.currentRegionIndex = regionIndex;
                ret = true;
            }
        }
        return ret;
    }

    protected boolean switchRegionAndUploadIfNeededWithErrorResponse(ResponseInfo errorResponseInfo) {
        return errorResponseInfo != null && !errorResponseInfo.isOK() && errorResponseInfo.couldRetry() && this.config.allowBackupHost && this.switchRegionAndUpload();
    }

    protected IUploadRegion getTargetRegion() {
        if (this.regions == null || this.regions.size() == 0) {
            return null;
        }
        return this.regions.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IUploadRegion getCurrentRegion() {
        if (this.regions == null) {
            return null;
        }
        IUploadRegion region = null;
        BaseUpload baseUpload = this;
        synchronized (baseUpload) {
            if (this.currentRegionIndex < this.regions.size()) {
                region = this.regions.get(this.currentRegionIndex);
            }
        }
        return region;
    }

    protected UploadRegionRequestMetrics getCurrentRegionRequestMetrics() {
        return this.currentRegionRequestMetrics;
    }

    protected void addRegionRequestMetricsOfOneFlow(UploadRegionRequestMetrics metrics) {
        if (metrics == null) {
            return;
        }
        if (this.currentRegionRequestMetrics == null) {
            this.currentRegionRequestMetrics = metrics;
        } else {
            this.currentRegionRequestMetrics.addMetrics(metrics);
        }
    }

    protected static interface UpTaskCompletionHandler {
        public void complete(ResponseInfo var1, String var2, UploadTaskMetrics var3, JSONObject var4);
    }
}

