/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.storage.UploadBlock;
import com.qiniu.android.storage.UploadData;
import com.qiniu.android.storage.UploadFileInfo;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class UploadFileInfoPartV1
extends UploadFileInfo {
    final ArrayList<UploadBlock> uploadBlocks;

    UploadFileInfoPartV1(long size, long modifyTime, ArrayList<UploadBlock> uploadBlocks) {
        super(size, modifyTime);
        this.uploadBlocks = uploadBlocks;
    }

    UploadFileInfoPartV1(long size, long blockSize, long dataSize, long modifyTime) {
        super(size, modifyTime);
        this.uploadBlocks = this.createBlocks(blockSize, dataSize);
    }

    static UploadFileInfoPartV1 fileFromJson(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        long size = 0L;
        long modifyTime = 0L;
        ArrayList<UploadBlock> uploadBlocks = new ArrayList<UploadBlock>();
        try {
            size = jsonObject.getLong("size");
            modifyTime = jsonObject.getLong("modifyTime");
            JSONArray blockJsonArray = jsonObject.getJSONArray("uploadBlocks");
            for (int i = 0; i < blockJsonArray.length(); ++i) {
                JSONObject blockJson = blockJsonArray.getJSONObject(i);
                UploadBlock block = UploadBlock.blockFromJson(blockJson);
                if (block == null) continue;
                uploadBlocks.add(block);
            }
        }
        catch (JSONException blockJsonArray) {
            // empty catch block
        }
        UploadFileInfoPartV1 fileInfo = new UploadFileInfoPartV1(size, modifyTime, uploadBlocks);
        return fileInfo;
    }

    private ArrayList<UploadBlock> createBlocks(long blockSize, long dataSize) {
        long offset = 0L;
        int blockIndex = 0;
        ArrayList<UploadBlock> blocks = new ArrayList<UploadBlock>();
        while (offset < this.size) {
            long lastSize = this.size - offset;
            long blockSizeP = Math.min(lastSize, blockSize);
            UploadBlock block = new UploadBlock(offset, blockSizeP, dataSize, blockIndex);
            if (block == null) continue;
            blocks.add(block);
            offset += blockSizeP;
            ++blockIndex;
        }
        return blocks;
    }

    @Override
    double progress() {
        if (this.uploadBlocks == null || this.uploadBlocks.size() == 0) {
            return 0.0;
        }
        double progress = 0.0;
        for (UploadBlock block : this.uploadBlocks) {
            progress += block.progress() * ((double)block.size / (double)this.size);
        }
        return progress;
    }

    @Override
    boolean isEmpty() {
        return this.uploadBlocks == null || this.uploadBlocks.size() == 0;
    }

    @Override
    boolean isValid() {
        return !this.isEmpty();
    }

    UploadBlock nextUploadBlock() {
        if (this.uploadBlocks == null || this.uploadBlocks.size() == 0) {
            return null;
        }
        UploadBlock block = null;
        for (UploadBlock blockP : this.uploadBlocks) {
            UploadData data = blockP.nextUploadData();
            if (data == null) continue;
            block = blockP;
            break;
        }
        return block;
    }

    @Override
    void clearUploadState() {
        if (this.uploadBlocks == null || this.uploadBlocks.size() == 0) {
            return;
        }
        for (UploadBlock block : this.uploadBlocks) {
            block.clearUploadState();
        }
    }

    @Override
    boolean isAllUploaded() {
        if (this.uploadBlocks == null || this.uploadBlocks.size() == 0) {
            return true;
        }
        boolean isAllUploaded = true;
        for (UploadBlock block : this.uploadBlocks) {
            if (block.isCompleted()) continue;
            isAllUploaded = false;
            break;
        }
        return isAllUploaded;
    }

    ArrayList<String> allBlocksContexts() {
        if (this.uploadBlocks == null || this.uploadBlocks.size() == 0) {
            return null;
        }
        ArrayList<String> contexts = new ArrayList<String>();
        for (UploadBlock block : this.uploadBlocks) {
            if (block.context == null) continue;
            contexts.add(block.context);
        }
        return contexts;
    }

    @Override
    JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("size", this.size);
            jsonObject.put("modifyTime", this.modifyTime);
            if (this.uploadBlocks != null && this.uploadBlocks.size() > 0) {
                JSONArray blockJsonArray = new JSONArray();
                for (UploadBlock block : this.uploadBlocks) {
                    JSONObject blockJson = block.toJsonObject();
                    if (blockJson == null) continue;
                    blockJsonArray.put((Object)blockJson);
                }
                jsonObject.put("uploadBlocks", (Object)blockJsonArray);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

