/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Process;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.TelephonyManager;
import com.qiniu.android.utils.ContextGetter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.List;

public final class AndroidNetwork {
    public static boolean isNetWorkReady() {
        Context c = ContextGetter.applicationContext();
        if (c == null) {
            return true;
        }
        ConnectivityManager connMgr = (ConnectivityManager)c.getSystemService("connectivity");
        try {
            NetworkInfo info = connMgr.getActiveNetworkInfo();
            return info != null && info.isConnected();
        }
        catch (Exception e) {
            return true;
        }
    }

    public static String getHostIP() {
        String hostIp = null;
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            InetAddress ia = null;
            block2: while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> ias = ni.getInetAddresses();
                while (ias.hasMoreElements()) {
                    ia = ias.nextElement();
                    if (ia.isLinkLocalAddress() || ia.isLoopbackAddress()) continue;
                    hostIp = ia.getHostAddress();
                    continue block2;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return hostIp;
    }

    public static String networkType(Context context) {
        if (context == null) {
            return "none";
        }
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return "none";
        }
        NetworkInfo networkInfo = connectivity.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            return "none";
        }
        int netWorkType = networkInfo.getType();
        if (netWorkType == 1) {
            return "wifi";
        }
        if (netWorkType == 0) {
            return AndroidNetwork.getNetWorkClass(context);
        }
        return "none";
    }

    private static String getNetWorkClass(Context context) {
        if (context.checkPermission("android.permission.READ_PHONE_STATE", Process.myPid(), Process.myUid()) != 0) {
            return "none";
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            return "none";
        }
        switch (telephonyManager.getNetworkType()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return "2g";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return "3g";
            }
            case 13: {
                return "4g";
            }
        }
        return "none";
    }

    public static int getMobileDbm() {
        Context context = ContextGetter.applicationContext();
        int dbm = -1;
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        if (Build.VERSION.SDK_INT >= 17) {
            if (context.checkPermission("android.permission.ACCESS_COARSE_LOCATION", Process.myPid(), Process.myUid()) != 0) {
                return dbm;
            }
            if (context.checkPermission("android.permission.ACCESS_FINE_LOCATION", Process.myPid(), Process.myUid()) != 0) {
                return dbm;
            }
            List cellInfoList = tm.getAllCellInfo();
            if (null != cellInfoList) {
                for (CellInfo cellInfo : cellInfoList) {
                    if (cellInfo instanceof CellInfoGsm) {
                        CellSignalStrengthGsm cellSignalStrengthGsm = ((CellInfoGsm)cellInfo).getCellSignalStrength();
                        dbm = cellSignalStrengthGsm.getDbm();
                        break;
                    }
                    if (cellInfo instanceof CellInfoCdma) {
                        CellSignalStrengthCdma cellSignalStrengthCdma = ((CellInfoCdma)cellInfo).getCellSignalStrength();
                        dbm = cellSignalStrengthCdma.getDbm();
                        break;
                    }
                    if (cellInfo instanceof CellInfoLte) {
                        CellSignalStrengthLte cellSignalStrengthLte = ((CellInfoLte)cellInfo).getCellSignalStrength();
                        dbm = cellSignalStrengthLte.getDbm();
                        break;
                    }
                    if (Build.VERSION.SDK_INT < 18 || !(cellInfo instanceof CellInfoWcdma)) continue;
                    CellSignalStrengthWcdma cellSignalStrengthWcdma = ((CellInfoWcdma)cellInfo).getCellSignalStrength();
                    dbm = cellSignalStrengthWcdma.getDbm();
                    break;
                }
            }
        }
        return dbm;
    }
}

