/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.common;

import com.qiniu.android.common.Config;
import com.qiniu.android.common.FixedZone;
import com.qiniu.android.common.Zone;
import com.qiniu.android.common.ZonesInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.DnsPrefetchTransaction;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.utils.SingleFlight;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

public final class AutoZone
extends Zone {
    private String ucServer;
    private Map<String, ZonesInfo> zonesInfoMap = new ConcurrentHashMap<String, ZonesInfo>();
    private ArrayList<RequestTransaction> transactions = new ArrayList();
    private static final SingleFlight SingleFlight = new SingleFlight();

    public void setUcServer(String ucServer) {
        this.ucServer = ucServer;
    }

    public List<String> getUcServerList() {
        if (this.ucServer != null) {
            ArrayList<String> serverList = new ArrayList<String>();
            serverList.add(this.ucServer);
            return serverList;
        }
        ArrayList<String> serverList = new ArrayList<String>();
        serverList.add(Config.preQueryHost00);
        serverList.add(Config.preQueryHost01);
        return serverList;
    }

    private String[] getUcServerArray() {
        if (this.ucServer != null) {
            return new String[]{this.ucServer};
        }
        return new String[]{Config.preQueryHost00, Config.preQueryHost01};
    }

    @Override
    public ZonesInfo getZonesInfo(UpToken token) {
        if (token == null) {
            return null;
        }
        ZonesInfo zonesInfo = this.zonesInfoMap.get(token.index());
        return zonesInfo;
    }

    @Override
    public void preQuery(final UpToken token, final Zone.QueryHandler completeHandler) {
        if (token == null || !token.isValid()) {
            completeHandler.complete(-1, ResponseInfo.invalidToken("invalid token"), null);
            return;
        }
        final String cacheKey = token.index();
        ZonesInfo zonesInfo = this.getZonesInfo(token);
        if (zonesInfo == null && (zonesInfo = GlobalCache.getInstance().zonesInfoForKey(cacheKey)) != null && zonesInfo.isValid()) {
            this.zonesInfoMap.put(cacheKey, zonesInfo);
        }
        if (zonesInfo != null && zonesInfo.isValid()) {
            completeHandler.complete(0, ResponseInfo.successResponse(), null);
            return;
        }
        DnsPrefetchTransaction.addDnsCheckAndPrefetchTransaction(this.getUcServerArray());
        try {
            SingleFlight.perform(cacheKey, new SingleFlight.ActionHandler(){

                public void action(final SingleFlight.CompleteHandler completeHandler) throws Exception {
                    final RequestTransaction transaction = AutoZone.this.createUploadRequestTransaction(token);
                    transaction.queryUploadHosts(true, new RequestTransaction.RequestCompleteHandler(){

                        @Override
                        public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                            AutoZone.this.destroyUploadRequestTransaction(transaction);
                            SingleFlightValue value = new SingleFlightValue();
                            value.responseInfo = responseInfo;
                            value.response = response;
                            value.metrics = requestMetrics;
                            completeHandler.complete(value);
                        }
                    });
                }
            }, new SingleFlight.CompleteHandler(){

                public void complete(Object value) {
                    SingleFlightValue singleFlightValue = (SingleFlightValue)value;
                    ResponseInfo responseInfo = singleFlightValue.responseInfo;
                    UploadRegionRequestMetrics requestMetrics = singleFlightValue.metrics;
                    JSONObject response = singleFlightValue.response;
                    if (responseInfo != null && responseInfo.isOK() && response != null) {
                        ZonesInfo zonesInfoP = ZonesInfo.createZonesInfo(response);
                        AutoZone.this.zonesInfoMap.put(cacheKey, zonesInfoP);
                        GlobalCache.getInstance().cache(response, cacheKey);
                        completeHandler.complete(0, responseInfo, requestMetrics);
                    } else if (responseInfo.isNetworkBroken()) {
                        completeHandler.complete(-1, responseInfo, requestMetrics);
                    } else {
                        ZonesInfo zonesInfoP = FixedZone.localsZoneInfo().getZonesInfo(token);
                        AutoZone.this.zonesInfoMap.put(cacheKey, zonesInfoP);
                        completeHandler.complete(0, responseInfo, requestMetrics);
                    }
                }
            });
        }
        catch (Exception e) {
            completeHandler.complete(-1, ResponseInfo.localIOError(e.toString()), null);
        }
    }

    private RequestTransaction createUploadRequestTransaction(UpToken token) {
        List<String> hosts = this.getUcServerList();
        RequestTransaction transaction = new RequestTransaction(hosts, "sdkEmptyRegionId", token);
        this.transactions.add(transaction);
        return transaction;
    }

    private void destroyUploadRequestTransaction(RequestTransaction transaction) {
        this.transactions.remove(transaction);
    }

    private static class GlobalCache {
        private static GlobalCache globalCache = new GlobalCache();
        private ConcurrentHashMap<String, JSONObject> cache = new ConcurrentHashMap();

        private GlobalCache() {
        }

        private static GlobalCache getInstance() {
            return globalCache;
        }

        private void cache(JSONObject zonesInfo, String cacheKey) {
            if (cacheKey == null || cacheKey.isEmpty()) {
                return;
            }
            if (zonesInfo == null) {
                this.cache.remove(cacheKey);
            } else {
                this.cache.put(cacheKey, zonesInfo);
            }
        }

        private ZonesInfo zonesInfoForKey(String cacheKey) {
            if (cacheKey == null || cacheKey.isEmpty()) {
                return null;
            }
            return ZonesInfo.createZonesInfo(this.cache.get(cacheKey));
        }
    }

    private static class SingleFlightValue {
        private ResponseInfo responseInfo;
        private JSONObject response;
        private UploadRegionRequestMetrics metrics;

        private SingleFlightValue() {
        }
    }
}

