/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.dns;

import com.qiniu.android.dns.DnsManager;
import com.qiniu.android.http.dns.Dns;
import com.qiniu.android.http.dns.HttpDns;
import com.qiniu.android.http.dns.IDnsNetworkAddress;
import com.qiniu.android.http.dns.SystemDns;
import com.qiniu.android.storage.GlobalConfiguration;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.List;

public class HappyDns
implements Dns {
    private SystemDns systemDns;
    private HttpDns httpDns;
    private DnsQueryErrorHandler errorHandler;

    public HappyDns() {
        int dnsTimeout = GlobalConfiguration.getInstance().dnsResolveTimeout;
        this.systemDns = new SystemDns(dnsTimeout);
        this.httpDns = new HttpDns(dnsTimeout);
    }

    void setQueryErrorHandler(DnsQueryErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public List<IDnsNetworkAddress> lookup(String hostname) throws UnknownHostException {
        List<IDnsNetworkAddress> addressList = null;
        try {
            addressList = this.systemDns.lookup(hostname);
        }
        catch (IOException e) {
            this.handleDnsError(e, hostname);
        }
        if (addressList != null && addressList.size() > 0) {
            return addressList;
        }
        try {
            addressList = this.httpDns.lookup(hostname);
        }
        catch (IOException e) {
            this.handleDnsError(e, hostname);
        }
        return addressList;
    }

    private void handleDnsError(IOException e, String host) {
        if (this.errorHandler != null) {
            this.errorHandler.queryError(e, host);
        }
    }

    static interface DnsQueryErrorHandler
    extends DnsManager.QueryErrorHandler {
    }
}

