/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.metrics;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadMetrics;
import com.qiniu.android.http.request.Request;
import com.qiniu.android.utils.Utils;
import java.util.Date;
import org.json.JSONObject;

public class UploadSingleRequestMetrics
extends UploadMetrics {
    public String httpVersion;
    public UploadSingleRequestMetrics connectCheckMetrics;
    public Request request;
    public ResponseInfo response;
    public String clientName;
    public String clientVersion;
    public Date domainLookupStartDate;
    public Date domainLookupEndDate;
    public Date connectStartDate;
    public Date connectEndDate;
    public Date secureConnectionStartDate;
    public Date secureConnectionEndDate;
    public Date requestStartDate;
    public Date requestEndDate;
    public Date responseStartDate;
    public Date responseEndDate;
    public long countOfRequestHeaderBytesSent = 0L;
    public long countOfRequestBodyBytesSent = 0L;
    public long countOfResponseHeaderBytesReceived = 0L;
    public long countOfResponseBodyBytesReceived = 0L;
    public String localAddress;
    public Integer localPort;
    public String remoteAddress;
    public Integer remotePort;
    private long totalBytes = 0L;

    public long totalDnsTime() {
        return this.time(this.domainLookupStartDate, this.domainLookupEndDate);
    }

    public long totalConnectTime() {
        return this.time(this.connectStartDate, this.connectEndDate);
    }

    public long totalSecureConnectTime() {
        return this.time(this.secureConnectionStartDate, this.secureConnectionEndDate);
    }

    public long totalRequestTime() {
        return this.time(this.requestStartDate, this.requestEndDate);
    }

    public long totalWaitTime() {
        return this.time(this.requestEndDate, this.responseStartDate);
    }

    public long totalResponseTime() {
        return this.time(this.responseStartDate, this.responseEndDate);
    }

    public void setRequest(Request request) {
        if (request != null) {
            this.request = new Request(request.urlString, request.httpMethod, request.allHeaders, null, request.timeout);
            long headerLength = 0L;
            long bodyLength = 0L;
            if (request.allHeaders != null) {
                headerLength = new JSONObject(request.allHeaders).toString().length();
            }
            if (request.httpBody != null) {
                bodyLength = request.httpBody.length;
            }
            this.totalBytes = headerLength + bodyLength;
        }
    }

    public long totalBytes() {
        return this.totalBytes;
    }

    public Long bytesSend() {
        long bytesSend = this.countOfRequestHeaderBytesSent + this.countOfRequestBodyBytesSent;
        long totalBytes = this.totalBytes();
        if (bytesSend > totalBytes) {
            bytesSend = totalBytes;
        }
        return bytesSend;
    }

    public Long bytesReceived() {
        long bytesReceived = this.countOfResponseHeaderBytesReceived + this.countOfResponseBodyBytesReceived;
        if (bytesReceived < 0L) {
            bytesReceived = 0L;
        }
        return bytesReceived;
    }

    public Long perceptiveSpeed() {
        return Utils.calculateSpeed(this.bytesSend() + this.bytesReceived(), this.totalElapsedTime());
    }

    private long time(Date startDate, Date endDate) {
        return Utils.dateDuration(startDate, endDate);
    }
}

