/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.storage.UploadSource;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

abstract class UploadInfo {
    private String sourceId;
    private long sourceSize = -1L;
    protected String fileName = null;
    private UploadSource source;

    UploadInfo(UploadSource source) {
        this.source = source;
        this.sourceSize = source.getSize();
        this.sourceId = source.getId() != null ? source.getId() : "";
    }

    void setInfoFromJson(JSONObject jsonObject) {
        try {
            this.sourceSize = jsonObject.getLong("sourceSize");
            this.sourceId = jsonObject.optString("sourceId");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    boolean couldReloadSource() {
        return this.source.couldReloadSource();
    }

    boolean reloadSource() {
        return this.source.reloadSource();
    }

    boolean isSameUploadInfo(UploadInfo info) {
        if (info == null || !this.sourceId.equals(info.sourceId)) {
            return false;
        }
        return info.sourceSize <= -1L || this.sourceSize <= -1L || info.sourceSize == this.sourceSize;
    }

    String getSourceId() {
        return this.sourceId;
    }

    long getSourceSize() {
        return this.sourceSize;
    }

    boolean hasValidResource() {
        return this.source != null;
    }

    boolean isValid() {
        return this.hasValidResource();
    }

    abstract long uploadSize();

    abstract boolean isAllUploaded();

    abstract void clearUploadState();

    abstract void checkInfoStateAndUpdate();

    JSONObject toJsonObject() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("sourceId", (Object)this.sourceId);
            jsonObject.put("sourceSize", this.sourceSize);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    void close() {
        this.source.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] readData(int dataSize, long dataOffset) throws IOException {
        if (this.source == null) {
            throw new IOException("file is not exist");
        }
        byte[] data = null;
        UploadSource uploadSource = this.source;
        synchronized (uploadSource) {
            data = this.source.readData(dataSize, dataOffset);
        }
        if (data != null && (data.length != dataSize || data.length == 0)) {
            this.sourceSize = dataOffset + (long)data.length;
        }
        return data;
    }
}

