/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.metrics;

import com.qiniu.android.http.metrics.UploadMetrics;
import com.qiniu.android.http.metrics.UploadSingleRequestMetrics;
import com.qiniu.android.http.request.IUploadRegion;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class UploadRegionRequestMetrics
extends UploadMetrics {
    public final IUploadRegion region;
    private List<UploadSingleRequestMetrics> metricsList = new CopyOnWriteArrayList<UploadSingleRequestMetrics>();

    public UploadRegionRequestMetrics(IUploadRegion region) {
        this.region = region;
    }

    public Integer requestCount() {
        return this.metricsList.size();
    }

    public Long bytesSend() {
        if (this.metricsList.size() == 0) {
            return 0L;
        }
        long bytes = 0L;
        for (UploadSingleRequestMetrics metrics : this.metricsList) {
            if (metrics == null) continue;
            bytes += metrics.bytesSend().longValue();
        }
        return bytes;
    }

    public void addMetricsList(List<UploadSingleRequestMetrics> metricsList) {
        if (metricsList == null || metricsList.size() == 0) {
            return;
        }
        for (UploadSingleRequestMetrics metrics : metricsList) {
            if (metrics == null) continue;
            this.metricsList.add(metrics);
        }
    }

    public void addMetrics(UploadRegionRequestMetrics metrics) {
        String metricsRegionId;
        if (metrics == null || metrics.region == null || metrics.region.getZoneInfo() == null || metrics.region.getZoneInfo().regionId == null || this.region == null || this.region.getZoneInfo() == null || this.region.getZoneInfo().regionId == null || metrics.metricsList == null || metrics.metricsList.size() == 0) {
            return;
        }
        String thisRegionId = metrics.region.getZoneInfo().getRegionId();
        if (thisRegionId.equals(metricsRegionId = metrics.region.getZoneInfo().getRegionId())) {
            if (this.startDate != null && metrics.startDate != null && this.startDate.getTime() > metrics.startDate.getTime()) {
                this.startDate = metrics.startDate;
            }
            if (this.endDate != null && metrics.endDate != null && this.endDate.getTime() < metrics.endDate.getTime()) {
                this.endDate = metrics.endDate;
            }
            this.addMetricsList(metrics.metricsList);
        }
    }
}

