/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.http.request.handler.RequestProgressHandler;
import com.qiniu.android.storage.BaseUpload;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.UpProgress;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import org.json.JSONObject;

class FormUpload
extends BaseUpload {
    private boolean isAsync = true;
    private final UpProgress upProgress;
    private RequestTransaction uploadTransaction;

    protected FormUpload(byte[] data, String key, String fileName, UpToken token, UploadOptions option, Configuration config, BaseUpload.UpTaskCompletionHandler completionHandler) {
        super(data, key, fileName, token, option, config, completionHandler);
        this.upProgress = new UpProgress(this.option.progressHandler);
    }

    @Override
    protected void startToUpload() {
        super.startToUpload();
        LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " form\u4e0a\u4f20");
        this.uploadTransaction = new RequestTransaction(this.config, this.option, this.getTargetRegion(), this.getCurrentRegion(), this.key, this.token);
        RequestProgressHandler progressHandler = new RequestProgressHandler(){

            @Override
            public void progress(long totalBytesWritten, long totalBytesExpectedToWrite) {
                FormUpload.this.upProgress.progress(FormUpload.this.key, totalBytesWritten, totalBytesExpectedToWrite);
            }
        };
        this.uploadTransaction.uploadFormData(this.data, this.fileName, this.isAsync, progressHandler, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                FormUpload.this.addRegionRequestMetricsOfOneFlow(requestMetrics);
                if (!responseInfo.isOK()) {
                    if (!FormUpload.this.switchRegionAndUploadIfNeededWithErrorResponse(responseInfo)) {
                        FormUpload.this.completeAction(responseInfo, response);
                    }
                    return;
                }
                FormUpload.this.upProgress.notifyDone(FormUpload.this.key, FormUpload.this.data.length);
                FormUpload.this.completeAction(responseInfo, response);
            }
        });
    }
}

