/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.storage.UploadSource;
import com.qiniu.android.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;

class UploadSourceStream
implements UploadSource {
    private long readOffset = 0L;
    private InputStream inputStream;
    private String id;
    private long size = -1L;
    private String fileName;

    UploadSourceStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    protected InputStream getInputStream() {
        return this.inputStream;
    }

    protected void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return !StringUtils.isNullOrEmpty(this.id) ? this.id : this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public long getSize() {
        if (this.size > -1L) {
            return this.size;
        }
        return -1L;
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public boolean couldReloadSource() {
        return false;
    }

    @Override
    public boolean reloadSource() {
        this.readOffset = 0L;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readData(int dataSize, long dataOffset) throws IOException {
        if (this.inputStream == null) {
            throw new IOException("inputStream is empty");
        }
        byte[] buffer = null;
        UploadSourceStream uploadSourceStream = this;
        synchronized (uploadSourceStream) {
            block9: {
                boolean isEOF = false;
                while (true) {
                    if (this.readOffset == dataOffset) {
                        int readSize;
                        int ret;
                        buffer = new byte[dataSize];
                        for (readSize = 0; readSize < dataSize; readSize += ret) {
                            ret = this.inputStream.read(buffer, readSize, dataSize - readSize);
                            if (ret >= 0) continue;
                            isEOF = true;
                            break;
                        }
                        if (readSize < dataSize) {
                            byte[] newBuffer = new byte[readSize];
                            System.arraycopy(buffer, 0, newBuffer, 0, readSize);
                            buffer = newBuffer;
                        }
                        this.readOffset += (long)readSize;
                        if (isEOF) {
                            this.size = this.readOffset;
                        }
                        break block9;
                    }
                    if (this.readOffset >= dataOffset) break;
                    this.readOffset += this.inputStream.skip(dataOffset - this.readOffset);
                }
                throw new IOException("read stream data error");
            }
        }
        return buffer;
    }

    @Override
    public void close() {
    }
}

