/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.qiniu.android.storage.UploadSourceStream;
import com.qiniu.android.utils.ContextGetter;
import com.qiniu.android.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

@TargetApi(value=19)
class UploadSourceUri
extends UploadSourceStream {
    private Exception readException = null;
    private final Uri uri;
    private ContentResolver resolver;
    private String modifyDate = "";

    UploadSourceUri(Uri uri, ContentResolver resolver) {
        super(null);
        this.uri = uri;
        this.resolver = resolver;
        this.reloadSource();
        this.loadFileInfo();
    }

    @Override
    public String getId() {
        return this.getFileName() + "_" + this.modifyDate;
    }

    @Override
    public boolean couldReloadSource() {
        return this.uri != null && !StringUtils.isNullOrEmpty(this.uri.getScheme());
    }

    @Override
    public boolean reloadSource() {
        super.reloadSource();
        this.close();
        this.readException = null;
        InputStream inputStream = null;
        try {
            inputStream = this.createInputStream();
            this.setInputStream(inputStream);
        }
        catch (Exception e) {
            this.readException = e;
        }
        return inputStream != null;
    }

    @Override
    public byte[] readData(int dataSize, long dataOffset) throws IOException {
        if (this.readException != null) {
            throw new IOException(this.readException);
        }
        return super.readData(dataSize, dataOffset);
    }

    @Override
    public void close() {
        InputStream inputStream = this.getInputStream();
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private InputStream createInputStream() throws Exception {
        if (this.uri == null) {
            return null;
        }
        ContentResolver resolver = this.getContextResolver();
        if (resolver == null) {
            return null;
        }
        InputStream inputStream = null;
        inputStream = resolver.openInputStream(this.uri);
        return inputStream;
    }

    private void loadFileInfo() {
        if (this.uri == null) {
            return;
        }
        if ("file".equals(this.uri.getScheme())) {
            this.tryLoadFileInfoByPath();
        } else {
            this.tryLoadFileInfoByCursor();
        }
    }

    private void tryLoadFileInfoByPath() {
        File file;
        if (this.uri.getPath() != null && (file = new File(this.uri.getPath())).exists() && file.isFile()) {
            this.setFileName(file.getName());
            this.setSize(file.length());
            this.modifyDate = file.lastModified() + "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLoadFileInfoByCursor() {
        ContentResolver resolver = this.getContextResolver();
        if (resolver == null) {
            return;
        }
        Cursor cursor = null;
        try {
            cursor = resolver.query(this.uri, null, null, null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cursor == null) {
            return;
        }
        try {
            if (cursor.moveToFirst()) {
                int modifyDateIndex;
                int fileNameIndex;
                String path;
                int dataIndex = cursor.getColumnIndex("_data");
                if (!cursor.isNull(dataIndex) && (path = cursor.getString(dataIndex)) != null) {
                    File file = new File(path);
                    this.setSize(file.length());
                    this.setFileName(file.getName());
                    this.modifyDate = file.lastModified() / 1000L + "";
                    return;
                }
                int sizeIndex = cursor.getColumnIndex("_size");
                if (!cursor.isNull(sizeIndex)) {
                    long size = cursor.getLong(sizeIndex);
                    this.setSize(size);
                }
                if (!cursor.isNull(fileNameIndex = cursor.getColumnIndex("_display_name"))) {
                    this.setFileName(cursor.getString(fileNameIndex));
                }
                if (!cursor.isNull(modifyDateIndex = cursor.getColumnIndex("date_modified"))) {
                    this.modifyDate = cursor.getString(modifyDateIndex);
                }
            }
        }
        finally {
            cursor.close();
        }
    }

    private ContentResolver getContextResolver() {
        if (this.resolver != null) {
            return this.resolver;
        }
        Context context = ContextGetter.applicationContext();
        if (context != null) {
            this.resolver = context.getContentResolver();
        }
        return this.resolver;
    }
}

