/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.utils;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Process;
import com.qiniu.android.utils.AndroidNetwork;
import com.qiniu.android.utils.ContextGetter;
import com.qiniu.android.utils.IPAddressUtil;
import com.qiniu.android.utils.StringUtils;
import java.util.Arrays;
import java.util.Date;

public class Utils {
    private static Boolean isDebug = null;

    public static boolean isDebug() {
        if (isDebug != null) {
            return isDebug;
        }
        Context context = ContextGetter.applicationContext();
        if (context == null) {
            return false;
        }
        try {
            ApplicationInfo info = context.getApplicationInfo();
            isDebug = (info.flags & 2) != 0;
            return isDebug;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String sdkVerion() {
        return "8.3.4";
    }

    public static String sdkLanguage() {
        return "Android";
    }

    public static Integer getCurrentProcessID() {
        return Process.myPid();
    }

    public static Long getCurrentThreadID() {
        Thread thread = Thread.currentThread();
        return thread.getId();
    }

    public static String systemName() {
        return System.getProperty("os.name");
    }

    public static String systemVersion() {
        return System.getProperty("os.version");
    }

    public static Integer getCurrentSignalStrength() {
        return null;
    }

    public static String getCurrentNetworkType() {
        Context context = ContextGetter.applicationContext();
        if (context == null) {
            return "";
        }
        return AndroidNetwork.networkType(context);
    }

    public static long currentTimestamp() {
        return new Date().getTime();
    }

    public static long dateDuration(Date startDate, Date endDate) {
        if (startDate != null && endDate != null) {
            return endDate.getTime() - startDate.getTime();
        }
        return 0L;
    }

    public static Long calculateSpeed(Long bytes, Long totalTime) {
        if (bytes == null || bytes < 0L || totalTime == null || totalTime == 0L) {
            return null;
        }
        return bytes * 1000L / totalTime;
    }

    public static String sdkDirectory() {
        Context context = ContextGetter.applicationContext();
        if (context == null) {
            return null;
        }
        String directory = context.getCacheDir().getAbsolutePath() + "/qiniu";
        return directory;
    }

    public static String formEscape(String string) {
        if (string == null) {
            return null;
        }
        String ret = string;
        ret = ret.replace("\\", "\\\\");
        ret = ret.replace("\"", "\\\"");
        return ret;
    }

    public static String getIpType(String ip, String host) {
        String type = host;
        if (ip == null || ip.length() == 0) {
            return type;
        }
        if (ip.contains(":")) {
            type = Utils.getIPV6StringType(ip, host);
        } else if (ip.contains(".")) {
            type = Utils.getIPV4StringType(ip, host);
        }
        return type;
    }

    public static boolean isIpv6(String ip) {
        if (StringUtils.isNullOrEmpty(ip)) {
            return false;
        }
        return IPAddressUtil.isIPv6LiteralAddress(ip);
    }

    private static String getIPV4StringType(String ipv4String, String host) {
        if (host == null) {
            host = "";
        }
        String type = null;
        String[] ipNumberStrings = ipv4String.split("\\.");
        if (ipNumberStrings.length == 4) {
            int firstNumber = Integer.parseInt(ipNumberStrings[0]);
            if (firstNumber > 0 && firstNumber < 127) {
                type = "ipv4-A-" + firstNumber;
            } else if (firstNumber > 127 && firstNumber <= 191) {
                type = "ipv4-B-" + firstNumber + ipNumberStrings[1];
            } else if (firstNumber > 191 && firstNumber <= 223) {
                type = "ipv4-C-" + firstNumber + ipNumberStrings[1] + ipNumberStrings[2];
            }
        }
        type = host + "-" + type;
        return type;
    }

    private static String getIPV6StringType(String ipv6String, String host) {
        String ipNumberString;
        String ipNumberString2;
        int i;
        if (host == null) {
            host = "";
        }
        String[] ipNumberStrings = ipv6String.split(":");
        String[] ipNumberStringsReal = new String[]{"0000", "0000", "0000", "0000", "0000", "0000", "0000", "0000"};
        String[] suppleStrings = new String[]{"0000", "000", "00", "0", ""};
        for (i = 0; i < ipNumberStrings.length && (ipNumberString2 = ipNumberStrings[i]).length() > 0; ++i) {
            ipNumberStringsReal[i] = ipNumberString2 = suppleStrings[ipNumberString2.length()] + ipNumberString2;
        }
        int j = ipNumberStrings.length - 1;
        int indexReal = ipNumberStringsReal.length - 1;
        while (i < j && (ipNumberString = ipNumberStrings[j]).length() > 0) {
            ipNumberStringsReal[indexReal] = ipNumberString = suppleStrings[ipNumberString.length()] + ipNumberString;
            --j;
            --indexReal;
        }
        String[] typeNumberArray = Arrays.copyOfRange(ipNumberStringsReal, 0, 4);
        String numberInfo = StringUtils.join(typeNumberArray, "-");
        return host + "-ipv6-" + numberInfo;
    }
}

