/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.dns;

import com.qiniu.android.dns.Domain;
import com.qiniu.android.dns.IResolver;
import com.qiniu.android.dns.Record;
import com.qiniu.android.dns.dns.DnsUdpResolver;
import com.qiniu.android.http.dns.Dns;
import com.qiniu.android.http.dns.DnsNetworkAddress;
import com.qiniu.android.http.dns.IDnsNetworkAddress;
import com.qiniu.android.storage.GlobalConfiguration;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class UdpDns
implements Dns {
    private IResolver udpIpv4Resolver;
    private IResolver udpIpv6Resolver;

    public UdpDns(int timeout) {
        String[] udpIpv6Servers;
        String[] udpIpv4Servers = GlobalConfiguration.getInstance().getUdpDnsIpv4Servers();
        if (udpIpv4Servers != null && udpIpv4Servers.length > 0) {
            this.udpIpv4Resolver = new DnsUdpResolver(udpIpv4Servers, 1, timeout);
        }
        if ((udpIpv6Servers = GlobalConfiguration.getInstance().getUdpDnsIpv6Servers()) != null && udpIpv6Servers.length > 0) {
            this.udpIpv6Resolver = new DnsUdpResolver(udpIpv6Servers, 1, timeout);
        }
    }

    @Override
    public List<IDnsNetworkAddress> lookup(String hostname) throws UnknownHostException {
        if (!GlobalConfiguration.getInstance().udpDnsEnable) {
            return null;
        }
        if (this.udpIpv4Resolver == null && this.udpIpv6Resolver == null) {
            throw new UnknownHostException("resolver server is invalid");
        }
        Record[] records = null;
        if (this.udpIpv4Resolver != null) {
            try {
                records = this.udpIpv4Resolver.resolve(new Domain(hostname), null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((records == null || records.length == 0) && this.udpIpv6Resolver != null) {
            try {
                records = this.udpIpv6Resolver.resolve(new Domain(hostname), null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (records == null || records.length == 0) {
            return null;
        }
        ArrayList<IDnsNetworkAddress> addressList = new ArrayList<IDnsNetworkAddress>();
        for (Record record : records) {
            if (!record.isA() && !record.isAAAA()) continue;
            String source = "dns:<" + record.server + ">";
            DnsNetworkAddress address = new DnsNetworkAddress(hostname, record.value, record.timeStamp, source, record.timeStamp);
            addressList.add(address);
        }
        return addressList;
    }
}

