/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage.serverConfig;

import com.qiniu.android.common.Config;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.serverConfig.ServerConfig;
import com.qiniu.android.storage.serverConfig.ServerUserConfig;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONObject;

class ServerConfigSynchronizer {
    private static String Token;
    private static String[] Hosts;
    private static RequestTransaction serverConfigTransaction;
    private static RequestTransaction serverUserConfigTransaction;

    ServerConfigSynchronizer() {
    }

    static void setToken(String token) {
        Token = token;
    }

    static void setHosts(String[] hosts) {
        Hosts = hosts;
    }

    static void getServerConfigFromServer(final ServerConfigHandler handler) {
        if (handler == null) {
            return;
        }
        RequestTransaction transaction = ServerConfigSynchronizer.createServerConfigTransaction();
        if (transaction == null) {
            handler.handle(null);
            return;
        }
        transaction.serverConfig(true, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                if (responseInfo.isOK() && response != null) {
                    handler.handle(new ServerConfig(response));
                } else {
                    handler.handle(null);
                }
                ServerConfigSynchronizer.destroyServerConfigTransaction();
            }
        });
    }

    private static synchronized RequestTransaction createServerConfigTransaction() {
        if (serverConfigTransaction != null) {
            return null;
        }
        UpToken token = UpToken.parse(Token);
        if (token == null) {
            token = UpToken.getInvalidToken();
        }
        ArrayList<String> servers = new ArrayList<String>();
        if (Hosts != null && Hosts.length > 0) {
            servers.addAll(Arrays.asList(Hosts));
        } else {
            servers.add(Config.preQueryHost00);
            servers.add(Config.preQueryHost01);
        }
        serverConfigTransaction = new RequestTransaction(servers, token);
        return serverConfigTransaction;
    }

    private static synchronized void destroyServerConfigTransaction() {
        serverConfigTransaction = null;
    }

    static void getServerUserConfigFromServer(final ServerUserConfigHandler handler) {
        if (handler == null) {
            return;
        }
        RequestTransaction transaction = ServerConfigSynchronizer.createServerUserConfigTransaction();
        if (transaction == null) {
            handler.handle(null);
            return;
        }
        transaction.serverUserConfig(true, new RequestTransaction.RequestCompleteHandler(){

            @Override
            public void complete(ResponseInfo responseInfo, UploadRegionRequestMetrics requestMetrics, JSONObject response) {
                if (responseInfo.isOK() && response != null) {
                    handler.handle(new ServerUserConfig(response));
                } else {
                    handler.handle(null);
                }
                ServerConfigSynchronizer.destroyServerUserConfigTransaction();
            }
        });
    }

    private static synchronized RequestTransaction createServerUserConfigTransaction() {
        if (serverUserConfigTransaction != null || Token == null) {
            return null;
        }
        UpToken token = UpToken.parse(Token);
        if (token == null || !token.isValid()) {
            return null;
        }
        ArrayList<String> servers = new ArrayList<String>();
        if (Hosts != null && Hosts.length > 0) {
            servers.addAll(Arrays.asList(Hosts));
        } else {
            servers.add(Config.preQueryHost00);
            servers.add(Config.preQueryHost01);
        }
        serverUserConfigTransaction = new RequestTransaction(servers, token);
        return serverUserConfigTransaction;
    }

    private static synchronized void destroyServerUserConfigTransaction() {
        serverUserConfigTransaction = null;
    }

    static interface ServerUserConfigHandler {
        public void handle(ServerUserConfig var1);
    }

    static interface ServerConfigHandler {
        public void handle(ServerConfig var1);
    }
}

