/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.dns;

import com.qiniu.android.http.dns.IDnsNetworkAddress;
import com.qiniu.android.storage.GlobalConfiguration;
import com.qiniu.android.utils.Utils;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

class DnsNetworkAddress
implements IDnsNetworkAddress,
Serializable {
    private final String hostValue;
    private final String ipValue;
    private final Long ttlValue;
    private final String sourceValue;
    private final Long timestampValue;

    static DnsNetworkAddress address(JSONObject jsonObject) {
        String hostValue = null;
        String ipValue = null;
        Long ttlValue = null;
        String sourceValue = null;
        Long timestampValue = null;
        try {
            hostValue = jsonObject.getString("hostValue");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            ipValue = jsonObject.getString("ipValue");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            ttlValue = jsonObject.getLong("ttlValue");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            timestampValue = jsonObject.getLong("timestampValue");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            sourceValue = jsonObject.getString("sourceValue");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        DnsNetworkAddress networkAddress = new DnsNetworkAddress(hostValue, ipValue, ttlValue, sourceValue, timestampValue);
        return networkAddress;
    }

    DnsNetworkAddress(String hostValue, String ipValue, Long ttlValue, String sourceValue, Long timestampValue) {
        this.hostValue = hostValue;
        this.ipValue = ipValue;
        this.ttlValue = ttlValue;
        this.sourceValue = sourceValue;
        this.timestampValue = timestampValue;
    }

    JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("hostValue", (Object)this.hostValue);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jsonObject.put("ipValue", (Object)this.ipValue);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jsonObject.put("ttlValue", (Object)this.ttlValue);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jsonObject.put("timestampValue", (Object)this.timestampValue);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jsonObject.put("sourceValue", (Object)this.sourceValue);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    @Override
    public String getHostValue() {
        return this.hostValue;
    }

    @Override
    public String getIpValue() {
        return this.ipValue;
    }

    @Override
    public Long getTtlValue() {
        return this.ttlValue;
    }

    @Override
    public String getSourceValue() {
        return this.sourceValue;
    }

    @Override
    public Long getTimestampValue() {
        return this.timestampValue;
    }

    boolean isValid() {
        if (this.timestampValue == null || this.ipValue == null || this.ipValue.length() == 0) {
            return false;
        }
        int maxTTL = GlobalConfiguration.getInstance().dnsCacheMaxTTL;
        return Utils.currentTimestamp() / 1000L < this.timestampValue + (long)maxTTL;
    }

    boolean needRefresh() {
        if (this.timestampValue == null || this.ttlValue == null || this.ipValue == null || this.ipValue.length() == 0) {
            return false;
        }
        int ttl = this.ttlValue.intValue();
        return Utils.currentTimestamp() / 1000L > this.timestampValue + (long)ttl;
    }
}

