/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.dns;

import com.qiniu.android.http.dns.Dns;
import com.qiniu.android.http.dns.DnsNetworkAddress;
import com.qiniu.android.http.dns.IDnsNetworkAddress;
import com.qiniu.android.storage.GlobalConfiguration;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SystemDns
implements Dns {
    private int timeout = 10;
    private static final ExecutorService executor = new ThreadPoolExecutor(1, 3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public SystemDns() {
    }

    public SystemDns(int timeout) {
        this.timeout = timeout;
    }

    public List<InetAddress> lookupInetAddress(final String hostname) throws UnknownHostException {
        if (hostname == null) {
            throw new UnknownHostException("hostname is null");
        }
        try {
            Future<List<InetAddress>> task = executor.submit(new Callable<List<InetAddress>>(){

                @Override
                public List<InetAddress> call() throws Exception {
                    return Arrays.asList(InetAddress.getAllByName(hostname));
                }
            });
            return task.get(this.timeout, TimeUnit.SECONDS);
        }
        catch (Exception var4) {
            UnknownHostException unknownHostException = new UnknownHostException("dns broken when lookup of " + hostname);
            unknownHostException.initCause(var4);
            throw unknownHostException;
        }
    }

    @Override
    public List<IDnsNetworkAddress> lookup(String hostname) throws UnknownHostException {
        long timestamp = new Date().getTime() / 1000L;
        long defaultTTL = GlobalConfiguration.getInstance().dnsCacheTime;
        ArrayList<IDnsNetworkAddress> addressList = new ArrayList<IDnsNetworkAddress>();
        List<InetAddress> inetAddressList = this.lookupInetAddress(hostname);
        for (InetAddress inetAddress : inetAddressList) {
            DnsNetworkAddress address = new DnsNetworkAddress(inetAddress.getHostName(), inetAddress.getHostAddress(), defaultTTL, "system", timestamp);
            addressList.add(address);
        }
        return addressList;
    }
}

