/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.storage.UploadData;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class UploadBlock {
    final long offset;
    final int size;
    final int index;
    final List<UploadData> uploadDataList;
    String md5 = null;
    String ctx = null;

    UploadBlock(long offset, int blockSize, int dataSize, int index) {
        this.offset = offset;
        this.size = blockSize;
        this.index = index;
        this.uploadDataList = this.createDataList(dataSize);
    }

    private UploadBlock(long offset, int blockSize, int index, List<UploadData> uploadDataList) {
        this.offset = offset;
        this.size = blockSize;
        this.index = index;
        this.uploadDataList = uploadDataList;
    }

    static UploadBlock blockFromJson(JSONObject jsonObject) throws Exception {
        if (jsonObject == null) {
            return null;
        }
        long offset = jsonObject.getLong("offset");
        int size = jsonObject.getInt("size");
        int index = jsonObject.getInt("index");
        String md5 = jsonObject.optString("md5");
        String ctx = jsonObject.optString("ctx");
        ArrayList<UploadData> uploadDataList = new ArrayList<UploadData>();
        JSONArray dataJsonArray = jsonObject.getJSONArray("uploadDataList");
        for (int i = 0; i < dataJsonArray.length(); ++i) {
            JSONObject dataJson = dataJsonArray.getJSONObject(i);
            UploadData data = UploadData.dataFromJson(dataJson);
            if (data == null) continue;
            uploadDataList.add(data);
        }
        UploadBlock block = new UploadBlock(offset, size, index, uploadDataList);
        block.md5 = md5;
        block.ctx = ctx;
        return block;
    }

    boolean isCompleted() {
        if (this.uploadDataList == null) {
            return true;
        }
        boolean isCompleted = true;
        for (UploadData data : this.uploadDataList) {
            if (data.isUploaded()) continue;
            isCompleted = false;
            break;
        }
        return isCompleted;
    }

    long uploadSize() {
        if (this.uploadDataList == null) {
            return 0L;
        }
        long uploadSize = 0L;
        for (UploadData data : this.uploadDataList) {
            uploadSize += data.uploadSize();
        }
        return uploadSize;
    }

    private ArrayList<UploadData> createDataList(int dataSize) {
        long offset = 0L;
        int dataIndex = 0;
        ArrayList<UploadData> datas = new ArrayList<UploadData>();
        while (offset < (long)this.size) {
            long lastSize = (long)this.size - offset;
            int dataSizeP = Math.min((int)lastSize, dataSize);
            UploadData data = new UploadData(offset, dataSizeP, dataIndex);
            datas.add(data);
            offset += (long)dataSizeP;
            ++dataIndex;
        }
        return datas;
    }

    void checkInfoStateAndUpdate() {
        for (UploadData data : this.uploadDataList) {
            data.checkStateAndUpdate();
        }
    }

    JSONObject toJsonObject() throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.putOpt("offset", (Object)this.offset);
        jsonObject.putOpt("size", (Object)this.size);
        jsonObject.putOpt("index", (Object)this.index);
        jsonObject.putOpt("md5", (Object)this.md5);
        jsonObject.putOpt("ctx", (Object)this.ctx);
        if (this.uploadDataList != null && this.uploadDataList.size() > 0) {
            JSONArray dataJsonArray = new JSONArray();
            for (UploadData data : this.uploadDataList) {
                JSONObject dataJson = data.toJsonObject();
                if (dataJson == null) continue;
                dataJsonArray.put((Object)dataJson);
            }
            jsonObject.put("uploadDataList", (Object)dataJsonArray);
        }
        return jsonObject;
    }

    protected UploadData nextUploadDataWithoutCheckData() {
        if (this.uploadDataList == null || this.uploadDataList.size() == 0) {
            return null;
        }
        UploadData data = null;
        for (UploadData dataP : this.uploadDataList) {
            if (!dataP.needToUpload()) continue;
            data = dataP;
            break;
        }
        return data;
    }

    protected void clearUploadState() {
        this.md5 = null;
        this.ctx = null;
        if (this.uploadDataList == null || this.uploadDataList.size() == 0) {
            return;
        }
        for (UploadData data : this.uploadDataList) {
            data.clearUploadState();
        }
    }
}

