/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage.serverConfig;

import com.qiniu.android.common.AutoZone;
import com.qiniu.android.http.dns.DnsPrefetcher;
import com.qiniu.android.storage.GlobalConfiguration;
import com.qiniu.android.storage.serverConfig.ServerConfig;
import com.qiniu.android.storage.serverConfig.ServerConfigCache;
import com.qiniu.android.storage.serverConfig.ServerConfigSynchronizer;
import com.qiniu.android.storage.serverConfig.ServerUserConfig;
import com.qiniu.android.transaction.TransactionManager;
import java.util.ArrayList;

public class ServerConfigMonitor {
    private static final String TransactionKey = "ServerConfig";
    private boolean enable = true;
    private ServerConfigCache cache = new ServerConfigCache();
    private static ServerConfigMonitor configMonitor = new ServerConfigMonitor();

    public static void setEnable(boolean enable) {
        ServerConfigMonitor.configMonitor.enable = enable;
    }

    public static void setToken(String token) {
        ServerConfigSynchronizer.setToken(token);
    }

    public static void setServerHosts(String[] hosts) {
        ServerConfigSynchronizer.setHosts(hosts);
    }

    public static void removeConfigCache() {
        ServerConfigMonitor.configMonitor.cache.removeConfigCache();
    }

    public static synchronized void startMonitor() {
        if (!ServerConfigMonitor.configMonitor.enable) {
            return;
        }
        TransactionManager transactionManager = TransactionManager.getInstance();
        boolean isExist = transactionManager.existTransactionsForName(TransactionKey);
        if (isExist) {
            return;
        }
        TransactionManager.Transaction transaction = new TransactionManager.Transaction(TransactionKey, 0, 10, new Runnable(){

            @Override
            public void run() {
                configMonitor.monitor();
            }
        });
        transactionManager.addTransaction(transaction);
    }

    public static synchronized void endMonitor() {
        TransactionManager transactionManager = TransactionManager.getInstance();
        ArrayList<TransactionManager.Transaction> transactions = transactionManager.transactionsForName(TransactionKey);
        if (transactions != null) {
            for (TransactionManager.Transaction transaction : transactions) {
                transactionManager.removeTransaction(transaction);
            }
        }
    }

    private void monitor() {
        ServerUserConfig serverUserConfig;
        ServerConfig serverConfig;
        if (!this.enable) {
            return;
        }
        if (this.cache.getConfig() == null) {
            ServerConfig config = this.cache.getConfigFromDisk();
            this.handleServerConfig(config);
            this.cache.setConfig(config);
        }
        if ((serverConfig = this.cache.getConfig()) == null || !serverConfig.isValid()) {
            ServerConfigSynchronizer.getServerConfigFromServer(new ServerConfigSynchronizer.ServerConfigHandler(){

                @Override
                public void handle(ServerConfig config) {
                    if (config == null) {
                        return;
                    }
                    ServerConfigMonitor.this.handleServerConfig(config);
                    ServerConfigMonitor.this.cache.setConfig(config);
                    ServerConfigMonitor.this.cache.saveConfigToDisk(config);
                }
            });
        }
        if (this.cache.getUserConfig() == null) {
            ServerUserConfig config = this.cache.getUserConfigFromDisk();
            this.handleServerUserConfig(config);
            this.cache.setUserConfig(config);
        }
        if ((serverUserConfig = this.cache.getUserConfig()) == null || !serverUserConfig.isValid()) {
            ServerConfigSynchronizer.getServerUserConfigFromServer(new ServerConfigSynchronizer.ServerUserConfigHandler(){

                @Override
                public void handle(ServerUserConfig config) {
                    if (config == null) {
                        return;
                    }
                    ServerConfigMonitor.this.handleServerUserConfig(config);
                    ServerConfigMonitor.this.cache.setUserConfig(config);
                    ServerConfigMonitor.this.cache.saveUserConfigToDisk(config);
                }
            });
        }
    }

    private void handleServerConfig(ServerConfig config) {
        ServerConfig.DnsConfig dnsConfig;
        ServerConfig.RegionConfig oldRegionConfig;
        if (config == null) {
            return;
        }
        ServerConfig serverConfig = this.cache.getConfig();
        ServerConfig.RegionConfig regionConfig = config.getRegionConfig();
        ServerConfig.RegionConfig regionConfig2 = oldRegionConfig = serverConfig != null ? serverConfig.getRegionConfig() : null;
        if (regionConfig != null && oldRegionConfig != null && regionConfig.getClearId() > oldRegionConfig.getClearId() && regionConfig.getClearCache()) {
            AutoZone.clearCache();
        }
        if ((dnsConfig = config.getDnsConfig()) != null) {
            ServerConfig.DohDnsConfig dohConfig;
            ServerConfig.UdpDnsConfig udpDnsConfig;
            ServerConfig.DnsConfig oldDnsConfig;
            if (dnsConfig.getEnable() != null) {
                GlobalConfiguration.getInstance().isDnsOpen = dnsConfig.getEnable();
            }
            ServerConfig.DnsConfig dnsConfig2 = oldDnsConfig = serverConfig != null ? serverConfig.getDnsConfig() : null;
            if (oldDnsConfig != null && dnsConfig.getClearId() > oldDnsConfig.getClearId() && dnsConfig.getClearCache()) {
                try {
                    DnsPrefetcher.getInstance().clearDnsCache();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((udpDnsConfig = dnsConfig.getUdpDnsConfig()) != null) {
                ServerConfig.DnsServer ipv6Servers;
                ServerConfig.DnsServer ipv4Servers;
                if (udpDnsConfig.getEnable() != null) {
                    GlobalConfiguration.getInstance().udpDnsEnable = udpDnsConfig.getEnable();
                }
                if ((ipv4Servers = udpDnsConfig.getIpv4Server()) != null && ipv4Servers.getIsOverride()) {
                    GlobalConfiguration.DefaultUdpDnsIpv4Servers = ipv4Servers.getServers();
                }
                if ((ipv6Servers = udpDnsConfig.getIpv6Server()) != null && ipv6Servers.getIsOverride()) {
                    GlobalConfiguration.DefaultUdpDnsIpv6Servers = ipv6Servers.getServers();
                }
            }
            if ((dohConfig = dnsConfig.getDohDnsConfig()) != null) {
                ServerConfig.DnsServer ipv6Servers;
                ServerConfig.DnsServer ipv4Servers;
                if (dohConfig.getEnable() != null) {
                    GlobalConfiguration.getInstance().dohEnable = dohConfig.getEnable();
                }
                if ((ipv4Servers = dohConfig.getIpv4Server()) != null && ipv4Servers.getIsOverride()) {
                    GlobalConfiguration.DefaultDohIpv4Servers = ipv4Servers.getServers();
                }
                if ((ipv6Servers = dohConfig.getIpv6Server()) != null && ipv6Servers.getIsOverride()) {
                    GlobalConfiguration.DefaultDohIpv6Servers = ipv6Servers.getServers();
                }
            }
        }
    }

    private void handleServerUserConfig(ServerUserConfig config) {
        if (config == null) {
            return;
        }
        if (config.getNetworkCheckEnable() != null) {
            GlobalConfiguration.getInstance().connectCheckEnable = config.getNetworkCheckEnable();
        }
    }
}

