/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.IUploadRegion;
import com.qiniu.android.http.request.RequestTransaction;
import com.qiniu.android.http.serverRegion.UploadDomainRegion;
import com.qiniu.android.storage.Configuration;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.UpProgress;
import com.qiniu.android.storage.UpToken;
import com.qiniu.android.storage.UploadInfo;
import com.qiniu.android.storage.UploadOptions;
import com.qiniu.android.storage.UploadSource;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

abstract class PartsUploadPerformer {
    private static final String kRecordFileInfoKey = "recordFileInfo";
    private static final String kRecordZoneInfoKey = "recordZoneInfo";
    final String key;
    final String fileName;
    final UploadSource uploadSource;
    private final UpProgress upProgress;
    final UpToken token;
    final UploadOptions options;
    final Configuration config;
    final Recorder recorder;
    final String recorderKey;
    private IUploadRegion targetRegion;
    protected IUploadRegion currentRegion;
    Long recoveredFrom;
    UploadInfo uploadInfo;
    List<RequestTransaction> uploadTransactions;

    PartsUploadPerformer(UploadSource uploadSource, String fileName, String key, UpToken token, UploadOptions options, Configuration config, String recorderKey) {
        this.uploadSource = uploadSource;
        this.key = key;
        this.fileName = fileName;
        this.token = token;
        this.options = options;
        this.config = config;
        this.recorder = config.recorder;
        this.recorderKey = recorderKey;
        this.upProgress = new UpProgress(this.options.progressHandler);
        this.initData();
    }

    void initData() {
        this.uploadTransactions = new ArrayList<RequestTransaction>();
        this.uploadInfo = this.getDefaultUploadInfo();
        this.recoverUploadInfoFromRecord();
    }

    boolean canReadFile() {
        return this.uploadInfo != null && this.uploadInfo.hasValidResource();
    }

    boolean couldReloadInfo() {
        return this.uploadInfo.couldReloadSource();
    }

    boolean reloadInfo() {
        return this.uploadInfo.reloadSource();
    }

    void closeFile() {
        if (this.uploadInfo != null) {
            this.uploadInfo.close();
        }
    }

    void switchRegion(IUploadRegion region) {
        if (this.uploadInfo != null) {
            this.uploadInfo.clearUploadState();
        }
        this.currentRegion = region;
        this.recoveredFrom = null;
        if (this.targetRegion == null) {
            this.targetRegion = region;
        }
    }

    void notifyProgress(Boolean isCompleted) {
        if (this.uploadInfo == null) {
            return;
        }
        if (isCompleted.booleanValue()) {
            this.upProgress.notifyDone(this.key, this.uploadInfo.getSourceSize());
        } else {
            this.upProgress.progress(this.key, this.uploadInfo.uploadSize(), this.uploadInfo.getSourceSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recordUploadInfo() {
        String key = this.recorderKey;
        if (this.recorder == null || key == null || key.length() == 0) {
            return;
        }
        PartsUploadPerformer partsUploadPerformer = this;
        synchronized (partsUploadPerformer) {
            JSONObject zoneInfoJson = null;
            JSONObject fileInfoJson = null;
            if (this.currentRegion != null && this.currentRegion.getZoneInfo() != null) {
                zoneInfoJson = this.currentRegion.getZoneInfo().detailInfo;
            }
            if (this.uploadInfo != null) {
                fileInfoJson = this.uploadInfo.toJsonObject();
            }
            if (zoneInfoJson != null && fileInfoJson != null) {
                JSONObject info = new JSONObject();
                try {
                    info.put(kRecordZoneInfoKey, (Object)zoneInfoJson);
                    info.put(kRecordFileInfoKey, (Object)fileInfoJson);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                this.recorder.set(key, info.toString().getBytes());
            }
        }
        LogUtil.i("key:" + StringUtils.toNonnullString(key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recordUploadInfo");
    }

    void removeUploadInfoRecord() {
        this.recoveredFrom = null;
        if (this.uploadInfo != null) {
            this.uploadInfo.clearUploadState();
        }
        if (this.recorder != null && this.recorderKey != null) {
            this.recorder.del(this.recorderKey);
        }
        LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " removeUploadInfoRecord");
    }

    void recoverUploadInfoFromRecord() {
        LogUtil.i("key:" + StringUtils.toNonnullString(this.key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recorder:" + StringUtils.toNonnullString(this.recorder) + " recoverUploadInfoFromRecord");
        String key = this.recorderKey;
        if (this.recorder == null || key == null || key.length() == 0 || this.uploadSource == null) {
            return;
        }
        byte[] data = this.recorder.get(key);
        if (data == null) {
            LogUtil.i("key:" + StringUtils.toNonnullString(key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recoverUploadInfoFromRecord data:null");
            return;
        }
        try {
            JSONObject info = new JSONObject(new String(data));
            ZoneInfo zoneInfo = ZoneInfo.buildFromJson(info.getJSONObject(kRecordZoneInfoKey));
            UploadInfo recoverUploadInfo = this.getUploadInfoFromJson(this.uploadSource, info.getJSONObject(kRecordFileInfoKey));
            if (zoneInfo != null && recoverUploadInfo != null && recoverUploadInfo.isValid() && this.uploadInfo.isSameUploadInfo(recoverUploadInfo)) {
                LogUtil.i("key:" + StringUtils.toNonnullString(key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recoverUploadInfoFromRecord valid");
                recoverUploadInfo.checkInfoStateAndUpdate();
                this.uploadInfo = recoverUploadInfo;
                UploadDomainRegion region = new UploadDomainRegion();
                region.setupRegionData(zoneInfo);
                this.currentRegion = region;
                this.targetRegion = region;
                this.recoveredFrom = recoverUploadInfo.uploadSize();
            } else {
                LogUtil.i("key:" + StringUtils.toNonnullString(key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recoverUploadInfoFromRecord invalid");
                this.recorder.del(key);
                this.currentRegion = null;
                this.targetRegion = null;
                this.recoveredFrom = null;
            }
        }
        catch (Exception e) {
            LogUtil.i("key:" + StringUtils.toNonnullString(key) + " recorderKey:" + StringUtils.toNonnullString(this.recorderKey) + " recoverUploadInfoFromRecord json:error");
            this.recorder.del(key);
            this.currentRegion = null;
            this.targetRegion = null;
            this.recoveredFrom = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RequestTransaction createUploadRequestTransaction() {
        RequestTransaction transaction = new RequestTransaction(this.config, this.options, this.targetRegion, this.currentRegion, this.key, this.token);
        PartsUploadPerformer partsUploadPerformer = this;
        synchronized (partsUploadPerformer) {
            if (this.uploadTransactions != null) {
                this.uploadTransactions.add(transaction);
            }
        }
        return transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyUploadRequestTransaction(RequestTransaction transaction) {
        if (transaction != null) {
            PartsUploadPerformer partsUploadPerformer = this;
            synchronized (partsUploadPerformer) {
                if (this.uploadTransactions != null) {
                    this.uploadTransactions.remove(transaction);
                }
            }
        }
    }

    abstract UploadInfo getDefaultUploadInfo();

    abstract UploadInfo getUploadInfoFromJson(UploadSource var1, JSONObject var2);

    abstract void serverInit(PartsUploadPerformerCompleteHandler var1);

    abstract void uploadNextData(PartsUploadPerformerDataCompleteHandler var1);

    abstract void completeUpload(PartsUploadPerformerCompleteHandler var1);

    static interface PartsUploadPerformerDataCompleteHandler {
        public void complete(boolean var1, ResponseInfo var2, UploadRegionRequestMetrics var3, JSONObject var4);
    }

    static interface PartsUploadPerformerCompleteHandler {
        public void complete(ResponseInfo var1, UploadRegionRequestMetrics var2, JSONObject var3);
    }
}

