/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage.serverConfig;

import com.qiniu.android.storage.FileRecorder;
import com.qiniu.android.storage.Recorder;
import com.qiniu.android.storage.serverConfig.ServerConfig;
import com.qiniu.android.storage.serverConfig.ServerUserConfig;
import com.qiniu.android.utils.Utils;
import org.json.JSONObject;

class ServerConfigCache {
    private ServerConfig config;
    private ServerUserConfig userConfig;
    private static String kServerConfigDiskKey = "ServerConfig:v1.0.0";
    private static String kServerUserConfigDiskKey = "ServerUserConfig:v1.0.0";
    private Recorder recorder;

    ServerConfigCache() {
    }

    synchronized ServerConfig getConfig() {
        return this.config;
    }

    synchronized void setConfig(ServerConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerConfig getConfigFromDisk() {
        byte[] configData = null;
        ServerConfigCache serverConfigCache = this;
        synchronized (serverConfigCache) {
            this.setupRecorder();
            configData = this.recorder.get(kServerConfigDiskKey);
        }
        if (configData == null) {
            return null;
        }
        JSONObject configJson = null;
        try {
            configJson = new JSONObject(new String(configData));
        }
        catch (Exception ignored) {
            ServerConfigCache serverConfigCache2 = this;
            synchronized (serverConfigCache2) {
                this.recorder.del(kServerConfigDiskKey);
            }
            return null;
        }
        return new ServerConfig(configJson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveConfigToDisk(ServerConfig config) {
        if (config == null || config.getInfo() == null) {
            return;
        }
        ServerConfigCache serverConfigCache = this;
        synchronized (serverConfigCache) {
            this.setupRecorder();
            this.recorder.set(kServerConfigDiskKey, config.getInfo().toString().getBytes());
        }
    }

    synchronized ServerUserConfig getUserConfig() {
        return this.userConfig;
    }

    synchronized void setUserConfig(ServerUserConfig userConfig) {
        this.userConfig = userConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerUserConfig getUserConfigFromDisk() {
        byte[] configData = null;
        ServerConfigCache serverConfigCache = this;
        synchronized (serverConfigCache) {
            this.setupRecorder();
            configData = this.recorder.get(kServerUserConfigDiskKey);
        }
        if (configData == null) {
            return null;
        }
        JSONObject configJson = null;
        try {
            configJson = new JSONObject(new String(configData));
        }
        catch (Exception ignored) {
            ServerConfigCache serverConfigCache2 = this;
            synchronized (serverConfigCache2) {
                this.recorder.del(kServerUserConfigDiskKey);
            }
            return null;
        }
        return new ServerUserConfig(configJson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveUserConfigToDisk(ServerUserConfig userConfig) {
        if (userConfig == null || userConfig.getInfo() == null) {
            return;
        }
        ServerConfigCache serverConfigCache = this;
        synchronized (serverConfigCache) {
            this.setupRecorder();
            this.recorder.set(kServerUserConfigDiskKey, userConfig.getInfo().toString().getBytes());
        }
    }

    public synchronized void removeConfigCache() {
        this.setupRecorder();
        this.setConfig(null);
        this.setUserConfig(null);
        this.recorder.del(kServerConfigDiskKey);
        this.recorder.del(kServerUserConfigDiskKey);
    }

    private void setupRecorder() {
        if (this.recorder == null) {
            try {
                this.recorder = new FileRecorder(Utils.sdkDirectory() + "/ServerConfig");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

