/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.serverRegion;

import com.qiniu.android.common.ZoneInfo;
import com.qiniu.android.http.ResponseInfo;
import com.qiniu.android.http.dns.DnsPrefetcher;
import com.qiniu.android.http.dns.IDnsNetworkAddress;
import com.qiniu.android.http.networkStatus.UploadServerNetworkStatus;
import com.qiniu.android.http.request.IUploadRegion;
import com.qiniu.android.http.request.IUploadServer;
import com.qiniu.android.http.request.UploadRequestState;
import com.qiniu.android.http.serverRegion.HttpServerManager;
import com.qiniu.android.http.serverRegion.UploadServer;
import com.qiniu.android.http.serverRegion.UploadServerFreezeManager;
import com.qiniu.android.http.serverRegion.UploadServerFreezeUtil;
import com.qiniu.android.storage.GlobalConfiguration;
import com.qiniu.android.utils.LogUtil;
import com.qiniu.android.utils.StringUtils;
import com.qiniu.android.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UploadDomainRegion
implements IUploadRegion {
    private static final int Http3FrozenTime = 86400;
    private boolean http3Enabled;
    private boolean ipv6Enabled;
    private boolean hasFreezeHost;
    private boolean isAllFrozen;
    private final UploadServerFreezeManager partialHttp2Freezer = new UploadServerFreezeManager();
    private final UploadServerFreezeManager partialHttp3Freezer = new UploadServerFreezeManager();
    private ArrayList<String> domainHostList;
    private HashMap<String, UploadServerDomain> domainHashMap;
    private ArrayList<String> oldDomainHostList;
    private HashMap<String, UploadServerDomain> oldDomainHashMap;
    private ZoneInfo zoneInfo;

    @Override
    public boolean isEqual(IUploadRegion region) {
        if (region == null) {
            return false;
        }
        if (region.getZoneInfo() == null && this.getZoneInfo() == null) {
            return true;
        }
        if (region.getZoneInfo() == null || this.getZoneInfo() == null) {
            return false;
        }
        if (region.getZoneInfo().getRegionId() == null && this.getZoneInfo().getRegionId() == null) {
            return true;
        }
        if (region.getZoneInfo().getRegionId() == null || this.getZoneInfo().getRegionId() == null) {
            return false;
        }
        return region.getZoneInfo().getRegionId().equals(this.getZoneInfo().getRegionId());
    }

    @Override
    public boolean isValid() {
        return !this.isAllFrozen && (this.domainHostList.size() > 0 || this.oldDomainHostList.size() > 0);
    }

    @Override
    public ZoneInfo getZoneInfo() {
        return this.zoneInfo;
    }

    @Override
    public void setupRegionData(ZoneInfo zoneInfo) {
        if (zoneInfo == null) {
            return;
        }
        this.zoneInfo = zoneInfo;
        this.isAllFrozen = false;
        this.ipv6Enabled = zoneInfo.ipv6;
        ArrayList<String> domainHostList = new ArrayList<String>();
        if (zoneInfo.domains != null) {
            domainHostList.addAll(zoneInfo.domains);
        }
        this.domainHostList = domainHostList;
        this.domainHashMap = this.createDomainDictionary(domainHostList);
        ArrayList<String> oldDomainHostList = new ArrayList<String>();
        if (zoneInfo.old_domains != null) {
            oldDomainHostList.addAll(zoneInfo.old_domains);
        }
        this.oldDomainHostList = oldDomainHostList;
        this.oldDomainHashMap = this.createDomainDictionary(oldDomainHostList);
        LogUtil.i("region :" + StringUtils.toNonnullString(domainHostList));
        LogUtil.i("region old:" + StringUtils.toNonnullString(oldDomainHostList));
    }

    private HashMap<String, UploadServerDomain> createDomainDictionary(List<String> hosts) {
        HashMap<String, UploadServerDomain> domainHashMap = new HashMap<String, UploadServerDomain>();
        for (int i = 0; i < hosts.size(); ++i) {
            String host = hosts.get(i);
            UploadServerDomain domain = new UploadServerDomain(host);
            domainHashMap.put(host, domain);
        }
        return domainHashMap;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IUploadServer getNextServer(UploadRequestState requestState, ResponseInfo responseInfo, IUploadServer freezeServer) {
        void var8_12;
        UploadServer uploadServer;
        if (this.isAllFrozen || requestState == null) {
            return null;
        }
        this.freezeServerIfNeed(responseInfo, freezeServer);
        ArrayList<String> hostList = this.domainHostList;
        HashMap<String, UploadServerDomain> domainInfo = this.domainHashMap;
        if (requestState.isUseOldServer() && this.oldDomainHostList != null && this.oldDomainHostList.size() > 0 && this.oldDomainHashMap != null && this.oldDomainHashMap.size() > 0) {
            hostList = this.oldDomainHostList;
            domainInfo = this.oldDomainHashMap;
        }
        UploadServer http3Server = null;
        if (this.couldUseHttp3() && requestState.couldUseHttp3()) {
            for (String string : hostList) {
                UploadServerDomain domain = domainInfo.get(string);
                if (domain == null) continue;
                UploadServer domainServer = domain.getServer(new UploadServerDomain.GetServerCondition(){

                    @Override
                    public boolean condition(String host, UploadServer serverP, UploadServer filterServer) {
                        String filterServerIP;
                        String string = filterServerIP = filterServer == null ? null : filterServer.getIp();
                        if (!UploadDomainRegion.this.ipv6Enabled && Utils.isIpv6(filterServerIP)) {
                            return false;
                        }
                        String frozenType = UploadServerFreezeUtil.getFrozenType(host, filterServerIP);
                        boolean isFrozen = UploadServerFreezeUtil.isTypeFrozenByFreezeManagers(frozenType, new UploadServerFreezeManager[]{UploadDomainRegion.this.partialHttp3Freezer, UploadServerFreezeUtil.globalHttp3Freezer()});
                        if (isFrozen || !HttpServerManager.getInstance().isServerSupportHttp3(host, filterServerIP)) {
                            return false;
                        }
                        return UploadServerNetworkStatus.isServerNetworkBetter(filterServer, serverP);
                    }
                });
                if (domainServer != null) {
                    domainServer.setHttpVersion(IUploadServer.HttpVersion3);
                }
                if ((http3Server = (UploadServer)UploadServerNetworkStatus.getBetterNetworkServer(domainServer, http3Server)) == null) continue;
                break;
            }
        }
        UploadServer http2Server = null;
        for (String host : hostList) {
            UploadServerDomain domain = domainInfo.get(host);
            if (domain == null) continue;
            UploadServer domainServer = domain.getServer(new UploadServerDomain.GetServerCondition(){

                @Override
                public boolean condition(String host, UploadServer serverP, UploadServer filterServer) {
                    String filterServerIP;
                    String string = filterServerIP = filterServer == null ? null : filterServer.getIp();
                    if (!UploadDomainRegion.this.ipv6Enabled && Utils.isIpv6(filterServerIP)) {
                        return false;
                    }
                    String frozenType = UploadServerFreezeUtil.getFrozenType(host, filterServerIP);
                    boolean isFrozen = UploadServerFreezeUtil.isTypeFrozenByFreezeManagers(frozenType, new UploadServerFreezeManager[]{UploadDomainRegion.this.partialHttp2Freezer, UploadServerFreezeUtil.globalHttp2Freezer()});
                    if (isFrozen) {
                        return false;
                    }
                    return UploadServerNetworkStatus.isServerNetworkBetter(filterServer, serverP);
                }
            });
            if (domainServer != null) {
                domainServer.setHttpVersion(IUploadServer.HttpVersion2);
            }
            if ((http2Server = (UploadServer)UploadServerNetworkStatus.getBetterNetworkServer(domainServer, http2Server)) == null) continue;
            break;
        }
        if ((uploadServer = (UploadServer)UploadServerNetworkStatus.getBetterNetworkServer(http3Server, http2Server)) == null && !this.hasFreezeHost && hostList.size() > 0) {
            UploadServer uploadServer2;
            int index = (int)(Math.random() * (double)hostList.size());
            String host = hostList.get(index);
            UploadServerDomain domain = domainInfo.get(host);
            if (domain != null && (uploadServer2 = domain.getOneServer()) != null) {
                uploadServer2.setHttpVersion(IUploadServer.HttpVersion2);
            }
            this.unfreezeServer((IUploadServer)var8_12);
        }
        if (var8_12 != null) {
            LogUtil.i("get server host:" + StringUtils.toNonnullString(var8_12.getHost()) + " ip:" + StringUtils.toNonnullString(var8_12.getIp()));
        } else {
            this.isAllFrozen = true;
            LogUtil.i("get server host:null ip:null");
        }
        return var8_12;
    }

    @Override
    public void updateIpListFormHost(String host) {
        UploadServerDomain domain;
        if (host == null) {
            return;
        }
        if (this.domainHashMap != null && this.domainHashMap.get(host) != null && (domain = this.domainHashMap.get(host)) != null) {
            domain.clearIpGroupList();
        }
        if (this.oldDomainHashMap != null && this.oldDomainHashMap.get(host) != null && (domain = this.oldDomainHashMap.get(host)) != null) {
            domain.clearIpGroupList();
        }
    }

    private void freezeServerIfNeed(ResponseInfo responseInfo, IUploadServer freezeServer) {
        if (responseInfo == null || freezeServer == null || freezeServer.getServerId() == null) {
            return;
        }
        String frozenType = UploadServerFreezeUtil.getFrozenType(freezeServer.getHost(), freezeServer.getIp());
        if (freezeServer.isHttp3()) {
            if (responseInfo.isNotQiniu() || !responseInfo.canConnectToHost() || responseInfo.isHostUnavailable()) {
                this.hasFreezeHost = true;
                this.partialHttp3Freezer.freezeType(frozenType, GlobalConfiguration.getInstance().partialHostFrozenTime);
            }
            if (IUploadServer.HttpVersion3.equals(responseInfo.httpVersion) || responseInfo.isHostUnavailable()) {
                this.hasFreezeHost = true;
                UploadServerFreezeUtil.globalHttp3Freezer().freezeType(frozenType, GlobalConfiguration.getInstance().globalHostFrozenTime);
            }
            return;
        }
        if (responseInfo.isNotQiniu() || !responseInfo.canConnectToHost() || responseInfo.isHostUnavailable()) {
            this.hasFreezeHost = true;
            LogUtil.i("partial freeze server host:" + StringUtils.toNonnullString(freezeServer.getHost()) + " ip:" + StringUtils.toNonnullString(freezeServer.getIp()));
            this.partialHttp2Freezer.freezeType(frozenType, GlobalConfiguration.getInstance().partialHostFrozenTime);
        }
        if (responseInfo.isHostUnavailable()) {
            this.hasFreezeHost = true;
            LogUtil.i("global freeze server host:" + StringUtils.toNonnullString(freezeServer.getHost()) + " ip:" + StringUtils.toNonnullString(freezeServer.getIp()));
            UploadServerFreezeUtil.globalHttp2Freezer().freezeType(frozenType, GlobalConfiguration.getInstance().globalHostFrozenTime);
        }
    }

    private void unfreezeServer(IUploadServer freezeServer) {
        if (freezeServer == null || freezeServer.getServerId() == null) {
            return;
        }
        String frozenType = UploadServerFreezeUtil.getFrozenType(freezeServer.getHost(), freezeServer.getIp());
        this.partialHttp2Freezer.unfreezeType(frozenType);
        this.partialHttp3Freezer.unfreezeType(frozenType);
    }

    private boolean couldUseHttp3() {
        return GlobalConfiguration.getInstance().enableHttp3;
    }

    private static class UploadIpGroup {
        private int addressIndex = -1;
        private final String groupType;
        private final ArrayList<IDnsNetworkAddress> addressList;

        protected UploadIpGroup(String groupType, ArrayList<IDnsNetworkAddress> addressList) {
            this.groupType = groupType;
            this.addressList = addressList;
        }

        protected IDnsNetworkAddress getNetworkAddress() {
            if (this.addressList == null || this.addressList.size() == 0) {
                return null;
            }
            if (this.addressIndex < 0 || this.addressIndex > this.addressList.size() - 1) {
                this.addressIndex = (int)(Math.random() * (double)this.addressList.size());
            }
            return this.addressList.get(this.addressIndex);
        }
    }

    private static class UploadServerDomain {
        protected final String host;
        protected ArrayList<UploadIpGroup> ipGroupList = new ArrayList();

        protected UploadServerDomain(String host) {
            this.host = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected UploadServer getServer(GetServerCondition condition) {
            if (this.host == null || this.host.length() == 0) {
                return null;
            }
            ArrayList<UploadIpGroup> ipGroups = null;
            UploadServerDomain uploadServerDomain = this;
            synchronized (uploadServerDomain) {
                if (this.ipGroupList == null || this.ipGroupList.size() == 0) {
                    this.createIpGroupList();
                }
                ipGroups = this.ipGroupList;
            }
            UploadServer server = null;
            if (ipGroups != null && ipGroups.size() > 0) {
                for (UploadIpGroup ipGroup : ipGroups) {
                    IDnsNetworkAddress networkAddress = ipGroup.getNetworkAddress();
                    UploadServer filterServer = new UploadServer(this.host, this.host, networkAddress.getIpValue(), networkAddress.getSourceValue(), networkAddress.getTimestampValue());
                    if (condition == null || condition.condition(this.host, server, filterServer)) {
                        server = filterServer;
                    }
                    if (condition != null) continue;
                    break;
                }
                return server;
            }
            UploadServer hostServer = new UploadServer(this.host, this.host, null, null, null);
            if (condition == null || condition.condition(this.host, null, hostServer)) {
                server = hostServer;
            }
            return server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected UploadServer getOneServer() {
            if (this.host == null || this.host.length() == 0) {
                return null;
            }
            ArrayList<UploadIpGroup> ipGroups = null;
            UploadServerDomain uploadServerDomain = this;
            synchronized (uploadServerDomain) {
                ipGroups = this.ipGroupList;
            }
            if (ipGroups != null && ipGroups.size() > 0) {
                int index = (int)(Math.random() * (double)ipGroups.size());
                UploadIpGroup ipGroup = (UploadIpGroup)ipGroups.get(index);
                IDnsNetworkAddress inetAddress = ipGroup.getNetworkAddress();
                UploadServer server = new UploadServer(this.host, this.host, inetAddress.getIpValue(), inetAddress.getSourceValue(), inetAddress.getTimestampValue());
                return server;
            }
            return new UploadServer(this.host, this.host, null, null, null);
        }

        synchronized void clearIpGroupList() {
            this.ipGroupList = null;
        }

        private void createIpGroupList() {
            if (this.ipGroupList != null && this.ipGroupList.size() > 0) {
                return;
            }
            List<IDnsNetworkAddress> networkAddresses = DnsPrefetcher.getInstance().getInetAddressByHost(this.host);
            if (networkAddresses == null || networkAddresses.size() == 0) {
                return;
            }
            HashMap<String, ArrayList<IDnsNetworkAddress>> ipGroupInfo = new HashMap<String, ArrayList<IDnsNetworkAddress>>();
            for (IDnsNetworkAddress networkAddress : networkAddresses) {
                String groupType;
                String ipValue = networkAddress.getIpValue();
                if (ipValue == null || (groupType = Utils.getIpType(ipValue, this.host)) == null) continue;
                ArrayList<IDnsNetworkAddress> groupNetworkAddresses = (ArrayList<IDnsNetworkAddress>)ipGroupInfo.get(groupType);
                if (groupNetworkAddresses == null) {
                    groupNetworkAddresses = new ArrayList<IDnsNetworkAddress>();
                }
                groupNetworkAddresses.add(networkAddress);
                ipGroupInfo.put(groupType, groupNetworkAddresses);
            }
            ArrayList<UploadIpGroup> ipGroupList = new ArrayList<UploadIpGroup>();
            for (String groupType : ipGroupInfo.keySet()) {
                ArrayList addresses = (ArrayList)ipGroupInfo.get(groupType);
                UploadIpGroup ipGroup = new UploadIpGroup(groupType, addresses);
                ipGroupList.add(ipGroup);
            }
            this.ipGroupList = ipGroupList;
        }

        protected static interface GetServerCondition {
            public boolean condition(String var1, UploadServer var2, UploadServer var3);
        }
    }
}

