/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.metrics;

import com.qiniu.android.http.metrics.UploadMetrics;
import com.qiniu.android.http.metrics.UploadRegionRequestMetrics;
import com.qiniu.android.http.request.IUploadRegion;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class UploadTaskMetrics
extends UploadMetrics {
    public ArrayList<IUploadRegion> regions;
    private String upType;
    private UploadRegionRequestMetrics ucQueryMetrics;
    private List<String> metricsKeys = new CopyOnWriteArrayList<String>();
    private Map<String, UploadRegionRequestMetrics> metricsInfo = new ConcurrentHashMap<String, UploadRegionRequestMetrics>();

    public UploadTaskMetrics(String upType) {
        this.upType = upType;
    }

    public Long requestCount() {
        long count = 0L;
        for (String key : this.metricsInfo.keySet()) {
            UploadRegionRequestMetrics metrics = this.metricsInfo.get(key);
            if (metrics == null) continue;
            count += (long)metrics.requestCount().intValue();
        }
        return count;
    }

    public Long bytesSend() {
        long bytesSend = 0L;
        for (String key : this.metricsInfo.keySet()) {
            UploadRegionRequestMetrics metrics = this.metricsInfo.get(key);
            if (metrics == null) continue;
            bytesSend += metrics.bytesSend().longValue();
        }
        return bytesSend;
    }

    public Long regionCount() {
        long count = 0L;
        for (String key : this.metricsInfo.keySet()) {
            UploadRegionRequestMetrics metrics = this.metricsInfo.get(key);
            if (metrics == null || metrics.region == null || metrics.region.getZoneInfo() == null || metrics.region.getZoneInfo().regionId.equals("unknown")) continue;
            ++count;
        }
        return count;
    }

    public UploadRegionRequestMetrics lastMetrics() {
        int size = this.metricsKeys.size();
        if (size < 1) {
            return null;
        }
        String key = this.metricsKeys.get(size - 1);
        return this.metricsInfo.get(key);
    }

    public void addMetrics(UploadRegionRequestMetrics metrics) {
        if (metrics == null || metrics.region == null || metrics.region.getZoneInfo() == null || metrics.region.getZoneInfo().regionId == null) {
            return;
        }
        String regionId = metrics.region.getZoneInfo().regionId;
        UploadRegionRequestMetrics metricsOld = this.metricsInfo.get(regionId);
        if (metricsOld != null) {
            metricsOld.addMetrics(metrics);
        } else {
            this.metricsKeys.add(regionId);
            this.metricsInfo.put(regionId, metrics);
        }
    }

    public String getUpType() {
        return this.upType;
    }

    public UploadRegionRequestMetrics getUcQueryMetrics() {
        return this.ucQueryMetrics;
    }

    public void setUcQueryMetrics(UploadRegionRequestMetrics ucQueryMetrics) {
        this.ucQueryMetrics = ucQueryMetrics;
        this.addMetrics(ucQueryMetrics);
    }
}

