/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.http.serverRegion;

import com.qiniu.android.utils.Utils;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

public class HttpServerManager {
    private ConcurrentHashMap<String, Long> serversInfo = new ConcurrentHashMap();
    private static final HttpServerManager manager = new HttpServerManager();

    public static HttpServerManager getInstance() {
        return manager;
    }

    public boolean addHttp3Server(String host, String ip, int liveDuration) {
        if (host == null || host.length() == 0 || ip == null || ip.length() == 0 || liveDuration < 0) {
            return false;
        }
        String type = this.getServerType(host, ip);
        long deadline = Utils.currentSecondTimestamp() + (long)liveDuration;
        this.serversInfo.put(type, deadline);
        return true;
    }

    public boolean isServerSupportHttp3(String host, String ip) {
        if (host == null || host.length() == 0 || ip == null || ip.length() == 0) {
            return false;
        }
        boolean support = false;
        String type = this.getServerType(host, ip);
        Long deadline = this.serversInfo.get(type);
        if (deadline != null && deadline > Utils.currentSecondTimestamp()) {
            support = true;
        }
        return support;
    }

    private String getServerType(String host, String ip) {
        return String.format(Locale.ENGLISH, "%s:%s", host, ip);
    }
}

