/*
 * Decompiled with CFR 0.152.
 */
package com.qiniu.android.storage;

import com.qiniu.android.storage.UpProgressBytesHandler;
import com.qiniu.android.storage.UpProgressHandler;
import com.qiniu.android.utils.AsyncRun;
import com.qiniu.android.utils.LogUtil;

class UpProgress {
    private volatile long maxProgressUploadBytes = -1L;
    private volatile long previousUploadBytes = 0L;
    private final UpProgressHandler handler;

    UpProgress(UpProgressHandler handler) {
        this.handler = handler;
    }

    public void progress(final String key, long uploadBytes, final long totalBytes) {
        if (this.handler == null || uploadBytes < 0L || totalBytes > 0L && uploadBytes > totalBytes) {
            return;
        }
        if (totalBytes > 0L) {
            if (this.maxProgressUploadBytes < 0L) {
                this.maxProgressUploadBytes = (long)((double)totalBytes * 0.95);
            }
            if (uploadBytes > this.maxProgressUploadBytes) {
                return;
            }
        }
        if (uploadBytes <= this.previousUploadBytes) {
            return;
        }
        this.previousUploadBytes = uploadBytes;
        if (this.handler instanceof UpProgressBytesHandler) {
            final long uploadBytesFinal = uploadBytes;
            AsyncRun.runInMain(new Runnable(){

                @Override
                public void run() {
                    LogUtil.i("key:" + key + " progress uploadBytes:" + uploadBytesFinal + " totalBytes:" + totalBytes);
                    ((UpProgressBytesHandler)UpProgress.this.handler).progress(key, uploadBytesFinal, totalBytes);
                }
            });
            return;
        }
        if (totalBytes < 0L) {
            return;
        }
        final double notifyPercent = (double)uploadBytes / (double)totalBytes;
        AsyncRun.runInMain(new Runnable(){

            @Override
            public void run() {
                LogUtil.i("key:" + key + " progress:" + notifyPercent);
                UpProgress.this.handler.progress(key, notifyPercent);
            }
        });
    }

    public void notifyDone(final String key, final long totalBytes) {
        if (this.handler == null) {
            return;
        }
        if (this.handler instanceof UpProgressBytesHandler) {
            AsyncRun.runInMain(new Runnable(){

                @Override
                public void run() {
                    LogUtil.i("key:" + key + " progress uploadBytes:" + totalBytes + " totalBytes:" + totalBytes);
                    ((UpProgressBytesHandler)UpProgress.this.handler).progress(key, totalBytes, totalBytes);
                }
            });
            return;
        }
        AsyncRun.runInMain(new Runnable(){

            @Override
            public void run() {
                LogUtil.i("key:" + key + " progress:1");
                UpProgress.this.handler.progress(key, 1.0);
            }
        });
    }
}

